/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.constraints.groups.groupsequenceisolation;

import jakarta.validation.Validator;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Size;
import java.util.Set;
import org.hibernate.beanvalidation.tck.tests.AbstractTCKTest;
import org.hibernate.beanvalidation.tck.tests.constraints.groups.groupsequenceisolation.B1;
import org.hibernate.beanvalidation.tck.tests.constraints.groups.groupsequenceisolation.B2;
import org.hibernate.beanvalidation.tck.tests.constraints.groups.groupsequenceisolation.B3;
import org.hibernate.beanvalidation.tck.tests.constraints.groups.groupsequenceisolation.C;
import org.hibernate.beanvalidation.tck.tests.constraints.groups.groupsequenceisolation.E;
import org.hibernate.beanvalidation.tck.tests.constraints.groups.groupsequenceisolation.IsAdult;
import org.hibernate.beanvalidation.tck.tests.constraints.groups.groupsequenceisolation.SafeEncryption;
import org.hibernate.beanvalidation.tck.util.ConstraintViolationAssert;
import org.hibernate.beanvalidation.tck.util.TestUtil;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="3.0.0")
public class GroupSequenceIsolationTest
extends AbstractTCKTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)GroupSequenceIsolationTest.webArchiveBuilder().withTestClassPackage(GroupSequenceIsolationTest.class)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-groupsequence-redefiningdefaultgroup", id="a"), @SpecAssertion(section="constraintdeclarationvalidationprocess-groupsequence-redefiningdefaultgroup", id="c"), @SpecAssertion(section="constraintdeclarationvalidationprocess-groupsequence-formaldefinition", id="c")})
    public void testCorrectDefaultSequenceInheritance() {
        Validator validator = TestUtil.getValidatorUnderTest();
        B1 b = new B1();
        b.name = "this name is too long";
        b.nickname = "and this nickname as well";
        b.size = 20;
        b.encryptionKey = "not safe";
        Set violations = validator.validate((Object)b, new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Size.class), ConstraintViolationAssert.violationOf(Size.class));
        b.name = "Jonathan";
        violations = validator.validate((Object)b, new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Size.class));
        b.nickname = "Jon";
        violations = validator.validate((Object)b, new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(SafeEncryption.class));
        b.encryptionKey = "secret";
        violations = validator.validate((Object)b, new Class[0]);
        ConstraintViolationAssert.assertNoViolations(violations);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-groupsequence-redefiningdefaultgroup", id="a"), @SpecAssertion(section="constraintdeclarationvalidationprocess-groupsequence-redefiningdefaultgroup", id="c"), @SpecAssertion(section="constraintdeclarationvalidationprocess-groupsequence-formaldefinition", id="c")})
    public void testCorrectDefaultSequenceInheritance2() {
        Validator validator = TestUtil.getValidatorUnderTest();
        B2 b = new B2();
        b.name = "this name is too long";
        b.nickname = "and this nickname as well";
        b.size = 20;
        b.encryptionKey = "not safe";
        Set violations = validator.validate((Object)b, new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Max.class));
        b.size = 10;
        violations = validator.validate((Object)b, new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Size.class), ConstraintViolationAssert.violationOf(Size.class));
        b.name = "Jonathan";
        violations = validator.validate((Object)b, new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Size.class));
        b.nickname = "Jon";
        violations = validator.validate((Object)b, new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(SafeEncryption.class));
        b.encryptionKey = "secret";
        violations = validator.validate((Object)b, new Class[0]);
        ConstraintViolationAssert.assertNoViolations(violations);
    }

    @Test
    @SpecAssertion(section="constraintdeclarationvalidationprocess-groupsequence-formaldefinition", id="b")
    public void testCorrectDefaultSequenceInheritance3() {
        Validator validator = TestUtil.getValidatorUnderTest();
        B3 b = new B3();
        b.name = "this name is too long";
        b.nickname = "and this nickname as well";
        b.size = 20;
        b.encryptionKey = "not safe";
        Set violations = validator.validate((Object)b, new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Max.class).withProperty("size"), ConstraintViolationAssert.violationOf(Size.class).withProperty("nickname"));
        b.nickname = "nick";
        violations = validator.validate((Object)b, new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Max.class).withProperty("size"));
        b.size = 10;
        violations = validator.validate((Object)b, new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Size.class).withProperty("name"));
        b.nickname = "and this nickname as well";
        violations = validator.validate((Object)b, new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Size.class).withProperty("name"), ConstraintViolationAssert.violationOf(Size.class).withProperty("nickname"));
    }

    @Test
    @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-graphvalidation", id="e")
    public void testCorrectDefaultSequenceContainedCaseWithoutGroupRedefinitionOnContainedEntity() {
        Validator validator = TestUtil.getValidatorUnderTest();
        C c = new C();
        c.name = "this name is too long";
        c.d.nickname = "and this nickname as well";
        c.size = 20;
        c.d.encryptionKey = "not safe";
        Set violations = validator.validate((Object)c, new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Max.class).withProperty("size"), ConstraintViolationAssert.violationOf(Size.class).withPropertyPath(ConstraintViolationAssert.pathWith().property("d").property("nickname")));
        c.size = 10;
        violations = validator.validate((Object)c, new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Size.class).withProperty("name"), ConstraintViolationAssert.violationOf(Size.class).withPropertyPath(ConstraintViolationAssert.pathWith().property("d").property("nickname")));
        c.d.nickname = "Jon";
        violations = validator.validate((Object)c, new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Size.class).withProperty("name"));
        c.name = "Johnatan";
        violations = validator.validate((Object)c, new Class[0]);
        ConstraintViolationAssert.assertNoViolations(violations);
    }

    @Test
    @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-graphvalidation", id="e")
    public void testCorrectDefaultSequenceContainedCaseWithGroupRedefinitionOnContainedEntity() {
        Validator validator = TestUtil.getValidatorUnderTest();
        E e = new E();
        e.name = "this name is too long";
        e.f.nickname = "and this nickname as well";
        e.size = 20;
        e.f.encryptionKey = "not safe";
        e.f.age = 16;
        Set violations = validator.validate((Object)e, new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Max.class).withProperty("size"), ConstraintViolationAssert.violationOf(Size.class).withPropertyPath(ConstraintViolationAssert.pathWith().property("f").property("nickname")));
        e.size = 10;
        violations = validator.validate((Object)e, new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Size.class).withProperty("name"), ConstraintViolationAssert.violationOf(Size.class).withPropertyPath(ConstraintViolationAssert.pathWith().property("f").property("nickname")));
        e.f.nickname = "Jon";
        violations = validator.validate((Object)e, new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Size.class).withProperty("name"), ConstraintViolationAssert.violationOf(IsAdult.class).withPropertyPath(ConstraintViolationAssert.pathWith().property("f").property("age")));
        e.f.age = 18;
        violations = validator.validate((Object)e, new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Size.class).withProperty("name"));
        e.name = "Johnatan";
        violations = validator.validate((Object)e, new Class[0]);
        ConstraintViolationAssert.assertNoViolations(violations);
    }
}

