/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.data;

import java.time.temporal.Temporal;
import java.time.temporal.TemporalUnit;
import org.assertj.core.data.TemporalOffset;
import org.assertj.core.util.Preconditions;

public abstract class TemporalUnitOffset
implements TemporalOffset<Temporal> {
    private final TemporalUnit unit;
    protected final long value;

    public TemporalUnitOffset(long value, TemporalUnit unit) {
        Preconditions.checkNotNull(unit);
        this.checkThatValueIsPositive(value);
        this.value = value;
        this.unit = unit;
    }

    private void checkThatValueIsPositive(long value) {
        Preconditions.checkArgument(value >= 0L, "The value of the offset should be greater than zero", new Object[0]);
    }

    @Override
    public String getBeyondOffsetDifferenceDescription(Temporal temporal1, Temporal temporal2) {
        return String.format("%s %s but difference was %s %s", this.value, this.unit, this.getDifference(temporal1, temporal2), this.unit);
    }

    protected long getDifference(Temporal temporal1, Temporal temporal2) {
        return Math.abs(this.unit.between(temporal1, temporal2));
    }

    public TemporalUnit getUnit() {
        return this.unit;
    }

    public long getValue() {
        return this.value;
    }
}

