/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.jboss.shrinkwrap.impl.base.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URLPackageScanner {
    private static final Logger log = Logger.getLogger(URLPackageScanner.class.getName());
    private static final String NAME_EMPTY_PACKAGE = "";
    private final String packageName;
    private final String packageNamePath;
    private final boolean addRecursively;
    private final ClassLoader classLoader;
    private Callback callback;

    public static URLPackageScanner newInstance(boolean addRecursively, ClassLoader classLoader, Callback callback, String packageName) {
        Validate.notNull(packageName, "Package name must be specified");
        Validate.notNull(addRecursively, "AddRecursively must be specified");
        Validate.notNull(classLoader, "ClassLoader must be specified");
        Validate.notNull(callback, "Callback must be specified");
        return new URLPackageScanner(packageName, addRecursively, classLoader, callback);
    }

    public static URLPackageScanner newInstance(boolean addRecursively, ClassLoader classLoader, Callback callback) {
        Validate.notNull(addRecursively, "AddRecursively must be specified");
        Validate.notNull(classLoader, "ClassLoader must be specified");
        Validate.notNull(callback, "Callback must be specified");
        return new URLPackageScanner(NAME_EMPTY_PACKAGE, addRecursively, classLoader, callback);
    }

    private URLPackageScanner(String packageName, boolean addRecursively, ClassLoader classLoader, Callback callback) {
        this.packageName = packageName;
        this.packageNamePath = packageName.replace(".", "/");
        this.addRecursively = addRecursively;
        this.classLoader = classLoader;
        this.callback = callback;
    }

    public void scanPackage() {
        try {
            HashSet<String> paths = new HashSet<String>();
            for (URL url : this.loadResources(this.packageNamePath)) {
                String urlPath = url.getFile();
                if ((urlPath = URLDecoder.decode(urlPath, "UTF-8")).startsWith("file:")) {
                    urlPath = urlPath.substring(5);
                }
                if (urlPath.indexOf(33) > 0) {
                    urlPath = urlPath.substring(0, urlPath.indexOf(33));
                }
                paths.add(urlPath);
            }
            this.handle(paths);
        }
        catch (IOException ioe) {
            log.log(Level.WARNING, "could not read: " + this.packageName, ioe);
        }
        catch (ClassNotFoundException ioe) {
            log.log(Level.WARNING, "Class coud not be loaded in package: " + this.packageName, ioe);
        }
    }

    private void handleArchiveByFile(File file) throws IOException, ClassNotFoundException {
        try {
            log.fine("archive: " + file);
            ZipFile zip = new ZipFile(file);
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String name = entry.getName();
                if (!name.startsWith(this.packageNamePath) || !name.endsWith(".class") || !this.addRecursively && name.substring(this.packageNamePath.length() + 1).contains("/")) continue;
                String className = name.replace("/", ".").substring(0, name.length() - ".class".length());
                this.foundClass(className);
            }
        }
        catch (ZipException e) {
            throw new RuntimeException("Error handling file " + file, e);
        }
    }

    private void handle(Set<String> paths) throws IOException, ClassNotFoundException {
        for (String urlPath : paths) {
            log.fine("scanning: " + urlPath);
            File file = new File(urlPath);
            if (file.isDirectory()) {
                this.handle(file, this.packageName);
                continue;
            }
            this.handleArchiveByFile(file);
        }
    }

    private void handle(File file, String packageName) throws ClassNotFoundException {
        for (File child : file.listFiles()) {
            if (!child.isDirectory() && child.getName().endsWith(".class")) {
                String packagePrefix = packageName.length() > 0 ? packageName + "." : packageName;
                this.foundClass(packagePrefix + child.getName().substring(0, child.getName().lastIndexOf(".class")));
                continue;
            }
            if (!child.isDirectory() || !this.addRecursively) continue;
            this.handle(child, packageName + "." + child.getName());
        }
    }

    private void foundClass(String className) {
        this.callback.classFound(className);
    }

    private List<URL> loadResources(String name) throws IOException {
        return Collections.list(this.classLoader.getResources(name));
    }

    public static interface Callback {
        public void classFound(String var1);
    }
}

