/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.extensions.producer;

import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.spi.AnnotatedField;
import jakarta.enterprise.inject.spi.AnnotatedMethod;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.BeforeShutdown;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.enterprise.inject.spi.InjectionTarget;
import jakarta.enterprise.inject.spi.ProcessInjectionTarget;
import jakarta.enterprise.inject.spi.ProcessProducer;
import jakarta.enterprise.inject.spi.Producer;
import java.util.Set;
import org.jboss.cdi.tck.tests.extensions.producer.BirdCage;
import org.jboss.cdi.tck.tests.extensions.producer.Cat;
import org.jboss.cdi.tck.tests.extensions.producer.CheckableInjectionTarget;
import org.jboss.cdi.tck.tests.extensions.producer.Cow;
import org.jboss.cdi.tck.tests.extensions.producer.CowProducer;
import org.jboss.cdi.tck.tests.extensions.producer.Dog;
import org.jboss.cdi.tck.tests.extensions.producer.DogProducer;
import org.jboss.cdi.tck.tests.extensions.producer.Noisy;
import org.jboss.cdi.tck.tests.extensions.producer.Quiet;

public class ProducerProcessor
implements Extension {
    private static InjectionTarget<Cat> catInjectionTarget;
    private static Producer<Dog> noisyDogProducer;
    private static Producer<Dog> quietDogProducer;
    private static InjectionTarget<Dog> dogInjectionTarget;
    private static AnnotatedType<Dog> dogAnnotatedType;
    private static boolean overriddenCowProducerCalled;

    public void cleanup(@Observes BeforeShutdown shutdown) {
        catInjectionTarget = null;
        noisyDogProducer = null;
        quietDogProducer = null;
        dogInjectionTarget = null;
        dogAnnotatedType = null;
    }

    public void processDogProducerProducer(@Observes ProcessProducer<DogProducer, Dog> producerEvent) {
        if (producerEvent.getAnnotatedMember().isAnnotationPresent(Noisy.class)) {
            noisyDogProducer = producerEvent.getProducer();
            assert (producerEvent.getAnnotatedMember() instanceof AnnotatedMethod);
        } else if (producerEvent.getAnnotatedMember().isAnnotationPresent(Quiet.class)) {
            quietDogProducer = producerEvent.getProducer();
            assert (producerEvent.getAnnotatedMember() instanceof AnnotatedField);
        }
    }

    public void processCatProducer(@Observes ProcessInjectionTarget<Cat> event) {
        catInjectionTarget = event.getInjectionTarget();
    }

    public void processDogInjectionTarget(@Observes ProcessInjectionTarget<Dog> injectionTargetEvent) {
        dogInjectionTarget = injectionTargetEvent.getInjectionTarget();
        dogAnnotatedType = injectionTargetEvent.getAnnotatedType();
    }

    public void processCowProducer(@Observes ProcessProducer<CowProducer, Cow> event) {
        final Producer producer = event.getProducer();
        event.setProducer((Producer)new Producer<Cow>(){

            public void dispose(Cow instance) {
                producer.dispose((Object)instance);
            }

            public Set<InjectionPoint> getInjectionPoints() {
                return producer.getInjectionPoints();
            }

            public Cow produce(CreationalContext<Cow> ctx) {
                overriddenCowProducerCalled = true;
                return (Cow)producer.produce(ctx);
            }
        });
    }

    public void processBirdCage(@Observes ProcessInjectionTarget<BirdCage> event) {
        event.setInjectionTarget(new CheckableInjectionTarget(event.getInjectionTarget()));
    }

    public static Producer<Dog> getNoisyDogProducer() {
        return noisyDogProducer;
    }

    public static Producer<Dog> getQuietDogProducer() {
        return quietDogProducer;
    }

    public static InjectionTarget<Cat> getCatInjectionTarget() {
        return catInjectionTarget;
    }

    public static InjectionTarget<Dog> getDogInjectionTarget() {
        return dogInjectionTarget;
    }

    public static AnnotatedType<Dog> getDogAnnotatedType() {
        return dogAnnotatedType;
    }

    public static void reset() {
        overriddenCowProducerCalled = false;
    }

    public static boolean isOverriddenCowProducerCalled() {
        return overriddenCowProducerCalled;
    }
}

