/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.interceptors.tests.order.overriden.lifecycleCallback;

import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.spi.Bean;
import java.lang.annotation.Annotation;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.interceptors.tests.order.overriden.lifecycleCallback.Bird;
import org.jboss.cdi.tck.interceptors.tests.order.overriden.lifecycleCallback.Eagle;
import org.jboss.cdi.tck.interceptors.tests.order.overriden.lifecycleCallback.Falcon;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="interceptors", version="1.2")
public class OverridenLifecycleCallbackInterceptorTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(OverridenLifecycleCallbackInterceptorTest.class)).build();
    }

    @Test
    @SpecAssertion(section="int_ordering_rules", id="j")
    public void testCallbackOverridenByCallback() {
        Bird.reset();
        Eagle.reset();
        Bean<Eagle> eagleBean = this.getUniqueBean(Eagle.class, new Annotation[0]);
        CreationalContext ctx = this.getCurrentManager().createCreationalContext(eagleBean);
        Eagle foo = (Eagle)eagleBean.create(ctx);
        foo.ping();
        eagleBean.destroy((Object)foo, ctx);
        Assert.assertEquals((int)Bird.getInitBirdCalled().get(), (int)0);
        Assert.assertEquals((int)Eagle.getInitEagleCalled().get(), (int)1);
        Assert.assertEquals((int)Bird.getDestroyBirdCalled().get(), (int)0);
        Assert.assertEquals((int)Eagle.getDestroyEagleCalled().get(), (int)1);
    }

    @Test
    @SpecAssertion(section="int_ordering_rules", id="j")
    public void testCallbackOverridenByNonCallback() {
        Bird.reset();
        Falcon.reset();
        Bean<Falcon> falconBean = this.getUniqueBean(Falcon.class, new Annotation[0]);
        CreationalContext ctx = this.getCurrentManager().createCreationalContext(falconBean);
        Falcon baz = (Falcon)falconBean.create(ctx);
        baz.ping();
        falconBean.destroy((Object)baz, ctx);
        Assert.assertEquals((int)Bird.getInitBirdCalled().get(), (int)0);
        Assert.assertEquals((int)Falcon.getInitFalconCalled().get(), (int)0);
        Assert.assertEquals((int)Bird.getDestroyBirdCalled().get(), (int)0);
        Assert.assertEquals((int)Falcon.getDestroyFalconCalled().get(), (int)0);
    }
}

