/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.event.eventTypes;

import jakarta.enterprise.event.Event;
import jakarta.enterprise.util.AnnotationLiteral;
import jakarta.inject.Inject;
import java.lang.annotation.Annotation;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.event.eventTypes.Broadcast;
import org.jboss.cdi.tck.tests.event.eventTypes.ComplexEvent;
import org.jboss.cdi.tck.tests.event.eventTypes.EventTypeFamilyObserver;
import org.jboss.cdi.tck.tests.event.eventTypes.Extra;
import org.jboss.cdi.tck.tests.event.eventTypes.Listener;
import org.jboss.cdi.tck.tests.event.eventTypes.Song;
import org.jboss.cdi.tck.tests.event.eventTypes.TuneSelect;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="2.0")
public class EventTypesTest
extends AbstractTest {
    private AnnotationLiteral<Extra> extraLiteral = new AnnotationLiteral<Extra>(){};
    @Inject
    Event<Song> songEvent;
    @Inject
    Event<Song[]> songArrayEvent;
    @Inject
    Event<int[]> intArrayEvent;

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(EventTypesTest.class)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="event_types_and_qualifier_types", id="aa"), @SpecAssertion(section="event_types_and_qualifier_types", id="j")})
    public void testEventTypeIsConcreteTypeWithNoTypeVariables() {
        Listener listener = this.getContextualReference(Listener.class, new Annotation[0]);
        listener.reset();
        Song s = new Song();
        this.getContextualReference(TuneSelect.class, new Annotation[0]).songPlaying(s);
        assert (listener.getObjectsFired().size() == 1);
        assert (listener.getObjectsFired().get(0) == s);
        this.songEvent.fire((Object)s);
        assert (listener.getObjectsFired().size() == 2);
        assert (listener.getObjectsFired().get(1) == s);
        Broadcast b = new Broadcast(){};
        this.getContextualReference(TuneSelect.class, new Annotation[0]).broadcastPlaying(b);
        assert (listener.getObjectsFired().size() == 3);
        assert (listener.getObjectsFired().get(2) == b);
        this.getCurrentManager().getEvent().select(new Annotation[]{this.extraLiteral}).fire((Object)1);
        assert (listener.getObjectsFired().size() == 4);
        assert (listener.getObjectsFired().get(3).equals(1));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="event_types_and_qualifier_types", id="j")})
    public void testEventTypeIsArray() {
        Listener listener = this.getContextualReference(Listener.class, new Annotation[0]);
        listener.reset();
        Song[] songArray = new Song[]{new Song()};
        this.songArrayEvent.fire((Object)songArray);
        Assert.assertEquals((int)listener.getObjectsFired().size(), (int)1);
        Assert.assertTrue((boolean)(listener.getObjectsFired().get(0) instanceof Song[]));
        Assert.assertEquals((Object)listener.getObjectsFired().get(0), (Object)songArray);
        Integer[] integerArray = new Integer[]{0, 1};
        this.getCurrentManager().getEvent().select(Integer[].class, new Annotation[0]).fire((Object)integerArray);
        Assert.assertEquals((int)listener.getObjectsFired().size(), (int)2);
        Assert.assertTrue((boolean)(listener.getObjectsFired().get(1) instanceof Integer[]));
        Assert.assertEquals((Object)listener.getObjectsFired().get(1), (Object)integerArray);
        int[] intArray = new int[]{1, 2};
        this.intArrayEvent.fire((Object)intArray);
        Assert.assertEquals((int)listener.getObjectsFired().size(), (int)3);
        Assert.assertTrue((boolean)(listener.getObjectsFired().get(2) instanceof int[]));
        Assert.assertEquals((Object)listener.getObjectsFired().get(2), (Object)intArray);
    }

    @Test
    @SpecAssertion(section="event_types_and_qualifier_types", id="c")
    public void testEventTypeIncludesAllSuperclassesAndInterfacesOfEventObject() {
        EventTypeFamilyObserver observer = this.getContextualReference(EventTypeFamilyObserver.class, new Annotation[0]);
        observer.reset();
        this.getCurrentManager().getEvent().select(ComplexEvent.class, new Annotation[0]).fire((Object)new ComplexEvent());
        assert (observer.getGeneralEventQuantity() == 1);
        assert (observer.getAbstractEventQuantity() == 1);
        assert (observer.getComplexEventQuantity() == 1);
        assert (observer.getObjectEventQuantity() == 1);
        assert (observer.getTotalEventsObserved() == 4);
    }
}

