/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.implementation.simple.definition;

import java.lang.annotation.Annotation;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.implementation.simple.definition.Antelope_NotBean;
import org.jboss.cdi.tck.tests.implementation.simple.definition.Car;
import org.jboss.cdi.tck.tests.implementation.simple.definition.Cow_NotBean;
import org.jboss.cdi.tck.tests.implementation.simple.definition.Donkey;
import org.jboss.cdi.tck.tests.implementation.simple.definition.OuterClass;
import org.jboss.cdi.tck.tests.implementation.simple.definition.Sheep;
import org.jboss.cdi.tck.tests.implementation.simple.definition.SimpleExtension;
import org.jboss.cdi.tck.tests.implementation.simple.definition.Tiger;
import org.jboss.cdi.tck.tests.implementation.simple.definition.Turkey;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="2.0")
public class SimpleBeanDefinitionTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(SimpleBeanDefinitionTest.class)).build();
    }

    @Test
    @SpecAssertion(section="what_classes_are_beans", id="ca")
    public void testAbstractClassDeclaredInJavaNotDiscovered() {
        Assert.assertEquals((int)this.getBeans(Cow_NotBean.class, new Annotation[0]).size(), (int)0);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="what_classes_are_beans", id="ba")})
    public void testStaticInnerClassDeclaredInJavaAllowed() {
        Assert.assertEquals((int)this.getBeans(OuterClass.StaticInnerClass.class, new Annotation[0]).size(), (int)1);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="what_classes_are_beans", id="b")})
    public void testNonStaticInnerClassDeclaredInJavaNotDiscovered() {
        Assert.assertEquals((int)this.getBeans(OuterClass.InnerClass_NotBean.class, new Annotation[0]).size(), (int)0);
    }

    @Test
    @SpecAssertion(section="what_classes_are_beans", id="cb")
    public void testInterfaceNotDiscoveredAsSimpleBean() {
        Assert.assertEquals((int)this.getBeans(Car.class, new Annotation[0]).size(), (int)0);
    }

    @Test
    @SpecAssertion(section="what_classes_are_beans", id="g")
    public void testExtensionNotDiscoveredAsSimpleBean() {
        Assert.assertEquals((int)this.getBeans(SimpleExtension.class, new Annotation[0]).size(), (int)0);
    }

    @Test
    @SpecAssertion(section="what_classes_are_beans", id="p")
    public void testSimpleBeanOnlyIfConstructorParameterless() {
        Assert.assertTrue((boolean)this.getBeans(Antelope_NotBean.class, new Annotation[0]).isEmpty());
        Assert.assertFalse((boolean)this.getBeans(Donkey.class, new Annotation[0]).isEmpty());
    }

    @Test
    @SpecAssertion(section="what_classes_are_beans", id="q")
    public void testSimpleBeanOnlyIfConstructorIsInitializer() {
        Assert.assertTrue((boolean)this.getBeans(Antelope_NotBean.class, new Annotation[0]).isEmpty());
        Assert.assertFalse((boolean)this.getBeans(Sheep.class, new Annotation[0]).isEmpty());
    }

    @Test
    @SpecAssertion(section="declaring_bean_constructor", id="aa")
    public void testInitializerAnnotatedConstructor() throws Exception {
        Sheep.constructedCorrectly = false;
        this.getContextualReference(Sheep.class, new Annotation[0]);
        Assert.assertTrue((boolean)Sheep.constructedCorrectly);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="declaring_bean_constructor", id="ba"), @SpecAssertion(section="declaring_managed_bean", id="a"), @SpecAssertion(section="bean_constructors", id="a"), @SpecAssertion(section="instantiation", id="ba")})
    public void testEmptyConstructorUsed() {
        Donkey.constructedCorrectly = false;
        this.getContextualReference(Donkey.class, new Annotation[0]);
        Assert.assertTrue((boolean)Donkey.constructedCorrectly);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="declaring_bean_constructor", id="aa"), @SpecAssertion(section="instantiation", id="aa")})
    public void testInitializerAnnotatedConstructorUsedOverEmptyConstuctor() throws Exception {
        this.getContextualReference(Turkey.class, new Annotation[0]);
        Assert.assertTrue((boolean)Turkey.constructedCorrectly);
    }

    @Test
    @SpecAssertion(section="managed_beans", id="fa")
    public void testDependentScopedBeanCanHaveNonStaticPublicField() throws Exception {
        Assert.assertEquals((String)this.getContextualReference(Tiger.class, (Annotation[])new Annotation[0]).name, (String)"pete");
    }
}

