/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.event.observer.priority.transactional;

import jakarta.annotation.Resource;
import jakarta.ejb.Stateless;
import jakarta.ejb.TransactionManagement;
import jakarta.ejb.TransactionManagementType;
import jakarta.enterprise.event.Event;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.transaction.UserTransaction;
import org.jboss.cdi.tck.tests.event.observer.priority.transactional.TxFailure;
import org.jboss.cdi.tck.tests.event.observer.priority.transactional.TxWithdrawal;
import org.jboss.cdi.tck.util.ActionSequence;

@Named
@Stateless
@TransactionManagement(value=TransactionManagementType.BEAN)
public class OnlineAccountService {
    @Resource
    private UserTransaction userTransaction;
    @Inject
    Event<TxWithdrawal> event;
    @Inject
    Event<TxFailure> eventFailure;

    public void withdrawSuccesTransaction(int amount) throws Exception {
        this.userTransaction.begin();
        this.event.fire((Object)new TxWithdrawal(amount));
        ActionSequence.addAction((String)"checkpoint");
        this.userTransaction.commit();
    }

    public void withdrawFailedTransaction(int amount) throws Exception {
        this.userTransaction.begin();
        this.event.fire((Object)new TxWithdrawal(amount));
        ActionSequence.addAction((String)"checkpoint");
        this.userTransaction.rollback();
    }

    public void withdrawNoTransaction(int amount) throws Exception {
        this.event.fire((Object)new TxWithdrawal(amount));
        ActionSequence.addAction((String)"checkpoint");
    }

    public void withdrawObserverFailedTransaction(int amount) throws Exception {
        this.userTransaction.begin();
        this.event.fire((Object)new TxWithdrawal(amount));
        this.eventFailure.fire((Object)new TxFailure());
        ActionSequence.addAction((String)"checkpoint");
        if (this.userTransaction.getStatus() == 1) {
            this.userTransaction.rollback();
        } else {
            this.userTransaction.commit();
        }
    }
}

