/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.context.application.async;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.inject.Inject;
import jakarta.servlet.AsyncEvent;
import jakarta.servlet.AsyncListener;
import java.io.IOException;
import org.jboss.cdi.tck.tests.context.application.async.SimpleApplicationBean;
import org.jboss.cdi.tck.tests.context.application.async.StatusBean;
import org.jboss.cdi.tck.util.SimpleLogger;

public class SimpleAsyncListener
implements AsyncListener {
    public static Long onStartAsync = null;
    public static Long onError = null;
    public static Long onTimeout = null;
    public static Long onComplete = null;
    public static boolean isApplicationContextActive = false;
    private static final SimpleLogger logger = new SimpleLogger(SimpleAsyncListener.class);
    @Inject
    SimpleApplicationBean simpleApplicationBean;
    @Inject
    BeanManager beanManager;
    @Inject
    StatusBean statusBean;

    public void onComplete(AsyncEvent event) throws IOException {
        logger.log("onComplete", new Object[0]);
        if (!this.statusBean.isOnTimeout() && !this.statusBean.isOnError()) {
            this.statusBean.setOnComplete(this.checkApplicationContextAvailability());
        }
    }

    public void onTimeout(AsyncEvent event) throws IOException {
        logger.log("onTimeout", new Object[0]);
        this.statusBean.setOnTimeout(this.checkApplicationContextAvailability());
        event.getAsyncContext().complete();
    }

    public void onError(AsyncEvent event) throws IOException {
        logger.log("onError", new Object[0]);
        this.statusBean.setOnError(this.checkApplicationContextAvailability());
        event.getAsyncContext().complete();
    }

    public void onStartAsync(AsyncEvent event) throws IOException {
        logger.log("onStartAsync", new Object[0]);
        this.statusBean.setOnStartAsync(this.checkApplicationContextAvailability());
    }

    private boolean checkApplicationContextAvailability() throws IOException {
        try {
            this.statusBean.setApplicationBeanAvailable(this.simpleApplicationBean.ping());
            isApplicationContextActive = this.beanManager.getContext(ApplicationScoped.class).isActive();
        }
        catch (Throwable e) {
            logger.log("Problem while checking application scope: " + e.getMessage(), new Object[0]);
        }
        return isApplicationContextActive && this.statusBean.isApplicationBeanAvailable();
    }
}

