/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.context.jms;

import jakarta.annotation.PostConstruct;
import jakarta.enterprise.context.Dependent;
import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import org.jboss.cdi.tck.impl.ConfigurationFactory;
import org.jboss.cdi.tck.util.JndiLookupUtils;
import org.jboss.cdi.tck.util.SimpleLogger;

@Dependent
public class SimpleMessageProducer {
    private static final SimpleLogger simpleLogger = new SimpleLogger(SimpleMessageProducer.class);
    private ConnectionFactory connectionFactory;
    private Queue queue;
    private Topic topic;

    @PostConstruct
    public void init() {
        this.connectionFactory = (ConnectionFactory)JndiLookupUtils.lookup((String)ConfigurationFactory.get().getTestJmsConnectionFactory());
        this.queue = (Queue)JndiLookupUtils.lookup((String)ConfigurationFactory.get().getTestJmsQueue());
        this.topic = (Topic)JndiLookupUtils.lookup((String)ConfigurationFactory.get().getTestJmsTopic());
    }

    public void sendQueueMessage() {
        Connection connection = null;
        Session session = null;
        MessageProducer messageProducer = null;
        TextMessage message = null;
        try {
            connection = this.connectionFactory.createConnection();
            session = connection.createSession(false, 1);
            messageProducer = session.createProducer((Destination)this.queue);
            message = session.createTextMessage();
            message.setText(SimpleMessageProducer.class.getName());
            messageProducer.send((Message)message);
        }
        catch (JMSException e) {
            throw new RuntimeException("Cannot send message", e);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (JMSException e) {
                    simpleLogger.log((Throwable)e);
                }
            }
        }
    }

    public void sendTopicMessage() {
        Connection connection = null;
        Session session = null;
        MessageProducer messageProducer = null;
        TextMessage message = null;
        try {
            connection = this.connectionFactory.createConnection();
            session = connection.createSession(false, 1);
            messageProducer = session.createProducer((Destination)this.topic);
            message = session.createTextMessage();
            message.setText(SimpleMessageProducer.class.getName());
            messageProducer.send((Message)message);
        }
        catch (JMSException e) {
            throw new RuntimeException("Cannot send message", e);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (JMSException e) {
                    simpleLogger.log((Throwable)e);
                }
            }
        }
    }
}

