/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.interceptors.tests.contract.lifecycleCallback;

import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.annotation.Priority;
import jakarta.interceptor.AroundInvoke;
import jakarta.interceptor.Interceptor;
import jakarta.interceptor.InvocationContext;
import java.util.HashSet;
import java.util.Set;
import org.jboss.cdi.tck.interceptors.tests.contract.lifecycleCallback.Animal;
import org.jboss.cdi.tck.interceptors.tests.contract.lifecycleCallback.AnimalBinding;
import org.testng.Assert;

@Interceptor
@AnimalBinding
@Priority(value=1)
public class AnimalInterceptor {
    private static Set<String> postConstructInterceptorCalledFor = new HashSet<String>();
    private static Set<String> preDestroyInterceptorCalledFor = new HashSet<String>();

    @PostConstruct
    public void postConstruct(InvocationContext ctx) {
        Animal target = (Animal)ctx.getTarget();
        Assert.assertNotNull((Object)target.getBar());
        postConstructInterceptorCalledFor.add(target.getAnimalType());
        try {
            ctx.proceed();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @AroundInvoke
    public Object intercept(InvocationContext ctx) throws Exception {
        if (ctx.getMethod().getName().equals("echo")) {
            return ctx.proceed() + ctx.getParameters()[0].toString();
        }
        return ctx.proceed();
    }

    @PreDestroy
    public void preDestroy(InvocationContext ctx) {
        preDestroyInterceptorCalledFor.add(((Animal)ctx.getTarget()).getAnimalType());
        try {
            ctx.proceed();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isPostConstructInterceptorCalled(String animalType) {
        return postConstructInterceptorCalledFor.contains(animalType);
    }

    public static boolean isPreDestroyInterceptorCalled(String animalType) {
        return preDestroyInterceptorCalledFor.contains(animalType);
    }
}

