/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.implementation.simple.resource.persistenceContext;

import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.util.AnnotationLiteral;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.ee.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.implementation.simple.resource.persistenceContext.Database;
import org.jboss.cdi.tck.tests.implementation.simple.resource.persistenceContext.ManagedBean;
import org.jboss.cdi.tck.tests.implementation.simple.resource.persistenceContext.ServiceBean;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@Test(groups={"integration", "persistence"})
@SpecVersion(spec="cdi", version="2.0")
public class PersistenceContextInjectionTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(PersistenceContextInjectionTest.class)).withBeansXml("beans.xml")).withDefaultPersistenceXml()).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="declaring_resource", id="cc"), @SpecAssertion(section="resource_lifecycle", id="lb"), @SpecAssertion(section="resource_lifecycle", id="mc")})
    public void testInjectionOfPersistenceContext() {
        ServiceBean serviceBean = (ServiceBean)this.getContextualReference(ServiceBean.class, new Annotation[0]);
        ManagedBean managedBean = serviceBean.getManagedBean();
        assert (managedBean.getPersistenceContext() != null) : "Persistence context was not injected into bean";
        assert (serviceBean.validateEntityManager());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="declaring_resource", id="dd"), @SpecAssertion(section="resource_lifecycle", id="lc"), @SpecAssertion(section="resource_lifecycle", id="me")})
    public void testInjectionOfPersistenceUnit() {
        Bean managedBeanBean = (Bean)this.getBeans(ManagedBean.class, new Annotation[0]).iterator().next();
        CreationalContext managedBeanCc = this.getCurrentManager().createCreationalContext((Contextual)managedBeanBean);
        ManagedBean managedBean = (ManagedBean)managedBeanBean.create(managedBeanCc);
        assert (managedBean.getPersistenceUnit() != null) : "Persistence unit was not injected into bean";
        assert (managedBean.getPersistenceUnit().isOpen()) : "Persistence unit not open injected into bean";
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="resource_lifecycle", id="md")})
    public void testPassivationOfPersistenceContext() throws Exception {
        Bean managedBeanBean = (Bean)this.getBeans(ManagedBean.class, new Annotation[0]).iterator().next();
        CreationalContext managedBeanCc = this.getCurrentManager().createCreationalContext((Contextual)managedBeanBean);
        ManagedBean managedBean = (ManagedBean)managedBeanBean.create(managedBeanCc);
        managedBean = (ManagedBean)this.activate(this.passivate(managedBean));
        assert (managedBean.getPersistenceContext() != null) : "Persistence context was not injected into bean";
        assert (managedBean.getPersistenceContext().getDelegate() != null) : "Persistence context not deserialized correctly";
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="resource_lifecycle", id="lc"), @SpecAssertion(section="resource_lifecycle", id="mf")})
    public void testPassivationOfPersistenceUnit() throws Exception {
        Bean managedBeanBean = (Bean)this.getBeans(ManagedBean.class, new Annotation[0]).iterator().next();
        CreationalContext managedBeanCc = this.getCurrentManager().createCreationalContext((Contextual)managedBeanBean);
        ManagedBean managedBean = (ManagedBean)managedBeanBean.create(managedBeanCc);
        managedBean = (ManagedBean)this.activate(this.passivate(managedBean));
        assert (managedBean.getPersistenceUnit() != null) : "Persistence unit was not injected into bean";
        assert (managedBean.getPersistenceUnit().isOpen()) : "Persistence unit not open injected into bean";
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="declaring_resource", id="hh"), @SpecAssertion(section="resource_types", id="ab")})
    public void testBeanTypesAndBindingTypesOfPersistenceContext() {
        Bean manager = (Bean)this.getBeans(EntityManager.class, new Annotation[]{new AnnotationLiteral<Database>(){}}).iterator().next();
        assert (manager.getTypes().size() == 3);
        assert (this.typeSetMatches(manager.getTypes(), new Type[]{EntityManager.class, Object.class, AutoCloseable.class}));
        assert (manager.getQualifiers().size() == 2);
        assert (this.annotationSetMatches(manager.getQualifiers(), new Class[]{Any.class, Database.class}));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="resource_types", id="ac")})
    public void testBeanTypesOfPersistenceUnit() {
        Bean factory = (Bean)this.getBeans(EntityManagerFactory.class, new Annotation[]{new AnnotationLiteral<Database>(){}}).iterator().next();
        assert (factory.getTypes().size() == 3);
        assert (this.typeSetMatches(factory.getTypes(), new Type[]{EntityManagerFactory.class, Object.class, AutoCloseable.class}));
    }
}

