/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.full.extensions.beanManager.bootstrap.unavailable.methods;

import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.Vetoed;
import jakarta.enterprise.inject.spi.AfterBeanDiscovery;
import jakarta.enterprise.inject.spi.AfterDeploymentValidation;
import jakarta.enterprise.inject.spi.AfterTypeDiscovery;
import jakarta.enterprise.inject.spi.Annotated;
import jakarta.enterprise.inject.spi.AnnotatedField;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.BeforeBeanDiscovery;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.enterprise.inject.spi.InterceptionType;
import jakarta.enterprise.inject.spi.ProcessAnnotatedType;
import jakarta.enterprise.inject.spi.ProcessBean;
import jakarta.enterprise.inject.spi.ProcessBeanAttributes;
import jakarta.enterprise.inject.spi.ProcessInjectionPoint;
import jakarta.enterprise.inject.spi.ProcessInjectionTarget;
import jakarta.enterprise.inject.spi.ProcessObserverMethod;
import jakarta.enterprise.util.AnnotationLiteral;
import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jboss.cdi.tck.tests.full.extensions.beanManager.bootstrap.unavailable.methods.Foo;
import org.jboss.cdi.tck.tests.full.extensions.beanManager.bootstrap.unavailable.methods.Transactional;
import org.testng.Assert;

public class WrongExtension
implements Extension {
    private Bean<Foo> fooBean;
    private InjectionPoint injectionPoint;

    public void observeBeforeBeanDiscovery(@Observes BeforeBeanDiscovery event, BeanManager beanManager) {
        this.testUnavailableMethodsBeforeABD(beanManager);
        this.testUnavailableMethodsBeforeADV(beanManager);
    }

    public void observeProcessAnnotatedType(@Observes ProcessAnnotatedType<?> event, BeanManager beanManager) {
        this.testUnavailableMethodsBeforeABD(beanManager);
        this.testUnavailableMethodsBeforeADV(beanManager);
    }

    public void observeAfterTypeDiscovery(@Observes AfterTypeDiscovery event, BeanManager beanManager) {
        this.testUnavailableMethodsBeforeABD(beanManager);
        this.testUnavailableMethodsBeforeADV(beanManager);
    }

    public void observeProcessInjectionTarget(@Observes ProcessInjectionTarget<Foo> event, BeanManager beanManager) {
        this.testUnavailableMethodsBeforeABD(beanManager);
        this.testUnavailableMethodsBeforeADV(beanManager);
    }

    public void observeInjectionPoint(@Observes ProcessInjectionPoint<Foo, ?> event, BeanManager beanManager) {
        if (this.injectionPoint == null) {
            this.injectionPoint = event.getInjectionPoint();
        }
        this.testUnavailableMethodsBeforeABD(beanManager);
        this.testUnavailableMethodsBeforeADV(beanManager);
    }

    public void observerProcessBeanAttributes(@Observes ProcessBeanAttributes<Foo> event, BeanManager beanManager) {
        this.testUnavailableMethodsBeforeABD(beanManager);
    }

    public void observeProcessBean(@Observes ProcessBean<Foo> event, BeanManager beanManager) {
        this.fooBean = event.getBean();
        this.testUnavailableMethodsBeforeABD(beanManager);
        this.testUnavailableMethodsBeforeADV(beanManager);
    }

    public void observerProcessObserverMethod(@Observes ProcessObserverMethod<Integer, Foo> event, BeanManager beanManager) {
        this.testUnavailableMethodsBeforeABD(beanManager);
        this.testUnavailableMethodsBeforeADV(beanManager);
    }

    public void observeAfterBeanDiscovery(@Observes AfterBeanDiscovery event, BeanManager beanManager) {
        this.testAvailableMethodsInABD(beanManager);
        this.testUnavailableMethodsBeforeADV(beanManager);
    }

    public void observerAfterDeploymentValidation(@Observes AfterDeploymentValidation event, BeanManager manager) {
        this.testAvailableMethodsInABD(manager);
        this.testAvailableMethodsInADV(manager);
    }

    private void testUnavailableMethodsBeforeABD(final BeanManager beanManager) {
        new Invocation(){

            @Override
            void execute() {
                beanManager.getBeans("foo");
            }
        }.run();
        new Invocation(){

            @Override
            void execute() {
                beanManager.getBeans(Foo.class, new Annotation[0]);
            }
        }.run();
        new Invocation(){

            @Override
            void execute() {
                beanManager.resolve(null);
            }
        }.run();
        new Invocation(){

            @Override
            void execute() {
                beanManager.resolveObserverMethods((Object)new Foo(), new Annotation[0]);
            }
        }.run();
        new Invocation(){

            @Override
            void execute() {
                beanManager.resolveInterceptors(InterceptionType.AROUND_INVOKE, new Annotation[]{new AnnotationLiteral<Transactional>(){}});
            }
        }.run();
        new Invocation(){

            @Override
            void execute() {
                beanManager.resolveDecorators(new HashSet<Class>(Arrays.asList(Foo.class)), new Annotation[0]);
            }
        }.run();
        new Invocation(){

            @Override
            void execute() {
                beanManager.validate(WrongExtension.this.injectionPoint);
            }
        }.run();
        new Invocation(){

            @Override
            void execute() {
                beanManager.getPassivationCapableBean("foo");
            }
        }.run();
    }

    private void testUnavailableMethodsBeforeADV(final BeanManager beanManager) {
        final CreationalContext creationalContext = beanManager.createCreationalContext(this.fooBean);
        new Invocation(){

            @Override
            void execute() {
                beanManager.getReference(WrongExtension.this.fooBean, Foo.class, creationalContext);
            }
        }.run();
        new Invocation(){

            @Override
            void execute() {
                beanManager.getInjectableReference(beanManager.createInjectionPoint((AnnotatedField)beanManager.createAnnotatedType(Foo.class).getFields().iterator().next()), creationalContext);
            }
        }.run();
        new Invocation(){

            @Override
            void execute() {
                beanManager.createInstance().select(Foo.class, new Annotation[0]);
            }
        }.run();
    }

    private void testAvailableMethodsInABD(BeanManager beanManager) {
        beanManager.getBeans("foo");
        beanManager.getBeans(Foo.class, new Annotation[0]);
        beanManager.resolve(null);
        beanManager.resolveObserverMethods((Object)new Foo(), new Annotation[0]);
        beanManager.resolveInterceptors(InterceptionType.AROUND_INVOKE, new Annotation[]{new AnnotationLiteral<Transactional>(){}});
        beanManager.resolveDecorators(new HashSet<Class>(Arrays.asList(Foo.class)), new Annotation[0]);
        beanManager.validate(this.injectionPoint);
        beanManager.getPassivationCapableBean("foo");
    }

    private void testAvailableMethodsInADV(BeanManager beanManager) {
        beanManager.getReference((Bean)new FooBean(), Foo.class, beanManager.createCreationalContext(null));
        beanManager.getInjectableReference(beanManager.createInjectionPoint((AnnotatedField)beanManager.createAnnotatedType(Foo.class).getFields().iterator().next()), beanManager.createCreationalContext(null));
    }

    private static abstract class Invocation {
        private Invocation() {
        }

        void run() {
            try {
                this.execute();
                Assert.fail((String)"Expected exception not thrown");
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }

        abstract void execute();
    }

    @Vetoed
    private static class FooInjectionPoint
    implements InjectionPoint {
        private FooInjectionPoint() {
        }

        public boolean isTransient() {
            return false;
        }

        public boolean isDelegate() {
            return false;
        }

        public Type getType() {
            return Foo.class;
        }

        public Set<Annotation> getQualifiers() {
            return null;
        }

        public Member getMember() {
            return null;
        }

        public Bean<?> getBean() {
            return null;
        }

        public Annotated getAnnotated() {
            return null;
        }
    }

    private static class FooBean
    implements Bean<Foo> {
        private FooBean() {
        }

        public Class<?> getBeanClass() {
            return Foo.class;
        }

        public Set<InjectionPoint> getInjectionPoints() {
            return Collections.emptySet();
        }

        public Set<Type> getTypes() {
            HashSet<Type> set = new HashSet<Type>();
            set.add((Type)((Object)Foo.class));
            return set;
        }

        public Set<Annotation> getQualifiers() {
            return Collections.emptySet();
        }

        public Class<? extends Annotation> getScope() {
            return Dependent.class;
        }

        public String getName() {
            return null;
        }

        public Set<Class<? extends Annotation>> getStereotypes() {
            return Collections.emptySet();
        }

        public boolean isAlternative() {
            return false;
        }

        public Foo create(CreationalContext<Foo> creationalContext) {
            return null;
        }

        public void destroy(Foo instance, CreationalContext<Foo> creationalContext) {
        }
    }
}

