/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.full.deployment.exclude;

import jakarta.inject.Inject;
import java.lang.annotation.Annotation;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.TestSystemProperty;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.full.deployment.exclude.Alpha;
import org.jboss.cdi.tck.tests.full.deployment.exclude.Bravo;
import org.jboss.cdi.tck.tests.full.deployment.exclude.Charlie;
import org.jboss.cdi.tck.tests.full.deployment.exclude.Delta;
import org.jboss.cdi.tck.tests.full.deployment.exclude.Echo;
import org.jboss.cdi.tck.tests.full.deployment.exclude.Foxtrot;
import org.jboss.cdi.tck.tests.full.deployment.exclude.Golf;
import org.jboss.cdi.tck.tests.full.deployment.exclude.Stubble;
import org.jboss.cdi.tck.tests.full.deployment.exclude.VerifyingExtension;
import org.jboss.cdi.tck.tests.full.deployment.exclude.food.Meat;
import org.jboss.cdi.tck.tests.full.deployment.exclude.haircut.Chonmage;
import org.jboss.cdi.tck.tests.full.deployment.exclude.mustache.Mustache;
import org.jboss.cdi.tck.tests.full.deployment.exclude.mustache.beard.Beard;
import org.jboss.shrinkwrap.api.BeanDiscoveryMode;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.impl.BeansXml;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"cdi-full"})
@SpecVersion(spec="cdi", version="2.0")
public class ExcludeFiltersTest
extends AbstractTest {
    @Inject
    VerifyingExtension extension;

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(ExcludeFiltersTest.class)).withPackage(Mustache.class.getPackage())).withPackage(Beard.class.getPackage())).withPackage(Chonmage.class.getPackage())).withPackage(Meat.class.getPackage())).withBeansXml(new BeansXml(BeanDiscoveryMode.ALL).excludeFilters(BeansXml.Exclude.match(Chonmage.class.getPackage().getName() + ".*"), BeansXml.Exclude.match(Mustache.class.getPackage().getName() + ".**"), BeansXml.Exclude.match(Meat.class.getPackage().getName() + ".*").ifClassAvailable("com.some.unreal.class.Name"), BeansXml.Exclude.match(Meat.class.getPackage().getName() + ".*").ifClassNotAvailable(ExcludeFiltersTest.class.getName()), BeansXml.Exclude.match(Alpha.class.getName()).ifClassAvailable(Stubble.class.getName()), BeansXml.Exclude.match(Stubble.class.getName()), BeansXml.Exclude.match(Foxtrot.class.getName()).ifClassAvailable("com.some.unreal.class.Name"), BeansXml.Exclude.match(Bravo.class.getName()).ifClassNotAvailable("com.some.unreal.class.Name"), BeansXml.Exclude.match(Echo.class.getName()).ifClassNotAvailable(ExcludeFiltersTest.class.getName()), BeansXml.Exclude.match(Charlie.class.getName()).ifSystemProperty(TestSystemProperty.EXCLUDE_DUMMY.getKey()), BeansXml.Exclude.match(Delta.class.getName()).ifSystemProperty(TestSystemProperty.EXCLUDE_DUMMY.getKey(), TestSystemProperty.EXCLUDE_DUMMY.getValue())))).withExtension(VerifyingExtension.class)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="exclude_filters", id="a"), @SpecAssertion(section="exclude_filters", id="f")})
    public void testTypeFcqnMatchesExcludeFilterName() {
        this.assertTypeIsExcluded(Stubble.class);
        this.assertTypeIsNotExcluded(Golf.class);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="exclude_filters", id="a"), @SpecAssertion(section="exclude_filters", id="g"), @SpecAssertion(section="exclude_filters", id="h")})
    public void testTypePackageMatchesExcludeFilterName() {
        this.assertTypeIsExcluded(Mustache.class);
        this.assertTypeIsExcluded(Beard.class);
        this.assertTypeIsExcluded(Chonmage.class);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="exclude_filters", id="b"), @SpecAssertion(section="exclude_filters", id="c")})
    public void testExcludeClassActivators() {
        this.assertTypeIsExcluded(Alpha.class);
        this.assertTypeIsNotExcluded(Foxtrot.class);
        this.assertTypeIsExcluded(Bravo.class);
        this.assertTypeIsNotExcluded(Echo.class);
        this.assertTypeIsNotExcluded(Meat.class);
    }

    @Test(groups={"integration", "systemProperties", "cdi-full"})
    @SpecAssertions(value={@SpecAssertion(section="exclude_filters", id="d"), @SpecAssertion(section="exclude_filters", id="e")})
    public void testExcludeSystemPropertyActivator() {
        this.assertTypeIsExcluded(Charlie.class);
        this.assertTypeIsExcluded(Delta.class);
    }

    private void assertTypeIsExcluded(Class<?> type) {
        Assert.assertTrue((boolean)this.getBeans(type, new Annotation[0]).isEmpty());
        Assert.assertFalse((boolean)this.extension.getObservedAnnotatedTypes().contains(type));
    }

    private void assertTypeIsNotExcluded(Class<?> type) {
        Assert.assertFalse((boolean)this.getBeans(type, new Annotation[0]).isEmpty());
        Assert.assertTrue((boolean)this.extension.getObservedAnnotatedTypes().contains(type));
    }
}

