/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.full.extensions.producer;

import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.enterprise.inject.spi.InjectionTarget;
import java.util.Set;

public class CheckableInjectionTarget<T>
implements InjectionTarget<T> {
    private InjectionTarget<T> wrappedInjectionTarget;
    private static boolean injectCalled;

    public CheckableInjectionTarget(InjectionTarget<T> originalInjectionTarget) {
        this.wrappedInjectionTarget = originalInjectionTarget;
    }

    public void inject(T instance, CreationalContext<T> ctx) {
        injectCalled = true;
        this.wrappedInjectionTarget.inject(instance, ctx);
    }

    public void postConstruct(T instance) {
        this.wrappedInjectionTarget.postConstruct(instance);
    }

    public void preDestroy(T instance) {
        this.wrappedInjectionTarget.preDestroy(instance);
    }

    public void dispose(T instance) {
        this.wrappedInjectionTarget.dispose(instance);
    }

    public Set<InjectionPoint> getInjectionPoints() {
        return this.wrappedInjectionTarget.getInjectionPoints();
    }

    public T produce(CreationalContext<T> ctx) {
        return (T)this.wrappedInjectionTarget.produce(ctx);
    }

    public static boolean isInjectCalled() {
        return injectCalled;
    }

    public static void setInjectCalled(boolean injectCalled) {
        CheckableInjectionTarget.injectCalled = injectCalled;
    }
}

