/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.event.select;

import jakarta.enterprise.util.TypeLiteral;
import java.lang.annotation.Annotation;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.event.select.AlarmSystem;
import org.jboss.cdi.tck.tests.event.select.BreakInEvent;
import org.jboss.cdi.tck.tests.event.select.NotABindingType;
import org.jboss.cdi.tck.tests.event.select.SecurityEvent;
import org.jboss.cdi.tck.tests.event.select.SecurityEvent_Illegal;
import org.jboss.cdi.tck.tests.event.select.SecuritySensor;
import org.jboss.cdi.tck.tests.event.select.SystemTest;
import org.jboss.cdi.tck.tests.event.select.Violent;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="2.0")
public class SelectEventTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(SelectEventTest.class)).build();
    }

    @Test
    @SpecAssertion(section="event", id="eaa")
    public void testEventSelectReturnsEventOfSameType() {
        AlarmSystem alarm = this.getContextualReference(AlarmSystem.class, new Annotation[0]);
        alarm.reset();
        SecuritySensor sensor = this.getContextualReference(SecuritySensor.class, new Annotation[0]);
        sensor.securityEvent.fire((Object)new SecurityEvent());
        assert (alarm.getNumSecurityEvents() == 1);
        assert (alarm.getNumSystemTests() == 0);
        assert (alarm.getNumBreakIns() == 0);
        assert (alarm.getNumViolentBreakIns() == 0);
        sensor.securityEvent.select(new Annotation[]{new SystemTest.SystemTestLiteral(""){}}).fire((Object)new SecurityEvent());
        assert (alarm.getNumSecurityEvents() == 2);
        assert (alarm.getNumSystemTests() == 1);
        assert (alarm.getNumBreakIns() == 0);
        assert (alarm.getNumViolentBreakIns() == 0);
        sensor.securityEvent.select(BreakInEvent.class, new Annotation[0]).fire((Object)new BreakInEvent());
        assert (alarm.getNumSecurityEvents() == 3);
        assert (alarm.getNumSystemTests() == 1);
        assert (alarm.getNumBreakIns() == 1);
        assert (alarm.getNumViolentBreakIns() == 0);
        sensor.securityEvent.select(BreakInEvent.class, new Annotation[]{new Violent.Literal()}).fire((Object)new BreakInEvent());
        assert (alarm.getNumSecurityEvents() == 4);
        assert (alarm.getNumSystemTests() == 1);
        assert (alarm.getNumBreakIns() == 2);
        assert (alarm.getNumViolentBreakIns() == 1);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    @SpecAssertion(section="event", id="eab")
    public <T> void testEventSelectThrowsExceptionIfEventTypeHasTypeVariable() {
        SecuritySensor sensor = this.getContextualReference(SecuritySensor.class, new Annotation[0]);
        sensor.securityEvent.select(new TypeLiteral<SecurityEvent_Illegal<T>>(){}, new Annotation[0]);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    @SpecAssertion(section="event", id="eba")
    public void testEventSelectThrowsExceptionForDuplicateBindingType() {
        SecuritySensor sensor = this.getContextualReference(SecuritySensor.class, new Annotation[0]);
        sensor.securityEvent.select(new Annotation[]{new SystemTest.SystemTestLiteral("a"){}, new SystemTest.SystemTestLiteral("b"){}});
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    @SpecAssertion(section="event", id="eba")
    public void testEventSelectWithSubtypeThrowsExceptionForDuplicateBindingType() {
        SecuritySensor sensor = this.getContextualReference(SecuritySensor.class, new Annotation[0]);
        sensor.securityEvent.select(BreakInEvent.class, new Annotation[]{new SystemTest.SystemTestLiteral("a"){}, new SystemTest.SystemTestLiteral("b"){}});
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    @SpecAssertion(section="event", id="ec")
    public void testEventSelectThrowsExceptionIfAnnotationIsNotBindingType() {
        SecuritySensor sensor = this.getContextualReference(SecuritySensor.class, new Annotation[0]);
        sensor.securityEvent.select(new Annotation[]{new NotABindingType.Literal()});
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    @SpecAssertion(section="event", id="ec")
    public void testEventSelectWithSubtypeThrowsExceptionIfAnnotationIsNotBindingType() {
        SecuritySensor sensor = this.getContextualReference(SecuritySensor.class, new Annotation[0]);
        sensor.securityEvent.select(BreakInEvent.class, new Annotation[]{new NotABindingType.Literal()});
    }
}

