/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.beanContainer.injection;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.inject.Default;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.spi.BeanContainer;
import jakarta.inject.Inject;
import java.lang.annotation.Annotation;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.beanContainer.injection.MyBean;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.testng.Assert;
import org.testng.annotations.Test;

public class BeanContainerInjectionTest
extends AbstractTest {
    @Inject
    MyBean myBean;
    @Inject
    Instance<Object> instance;

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(BeanContainerInjectionTest.class)).withClasses(MyBean.class)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="beancontainer", id="aa"), @SpecAssertion(section="beancontainer", id="ab"), @SpecAssertion(section="beancontainer", id="ac")})
    public void testInjectionOfBeanContainerType() {
        this.myBean.getBeanContainer().isNormalScope(ApplicationScoped.class);
        Instance beanContainerInstance = this.instance.select(BeanContainer.class, new Annotation[]{Default.Literal.INSTANCE});
        Assert.assertTrue((boolean)beanContainerInstance.isResolvable());
        Assert.assertEquals((Object)beanContainerInstance.getHandle().getBean().getScope(), Dependent.class);
    }
}

