/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.invokers.basic;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.build.compatible.spi.BeanInfo;
import jakarta.enterprise.inject.build.compatible.spi.BuildCompatibleExtension;
import jakarta.enterprise.inject.build.compatible.spi.InvokerFactory;
import jakarta.enterprise.inject.build.compatible.spi.Registration;
import jakarta.enterprise.inject.build.compatible.spi.Synthesis;
import jakarta.enterprise.inject.build.compatible.spi.SyntheticComponents;
import jakarta.enterprise.invoke.Invoker;
import java.util.Set;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.invokers.InvokerHolder;
import org.jboss.cdi.tck.tests.invokers.InvokerHolderCreator;
import org.jboss.cdi.tck.tests.invokers.InvokerHolderExtensionBase;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="4.1")
public class PrimitiveParametersInvokerTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClass(PrimitiveParametersInvokerTest.class)).withClasses(MyService.class)).withBuildCompatibleExtension(TestExtension.class)).withClasses(InvokerHolder.class, InvokerHolderCreator.class, InvokerHolderExtensionBase.class)).build();
    }

    @Test(dataProvider="ARQUILLIAN_DATA_PROVIDER")
    @SpecAssertions(value={@SpecAssertion(section="behavior_of_invoke", id="g"), @SpecAssertion(section="behavior_of_invoke", id="l")})
    public void test(MyService service, InvokerHolder invokers) throws Exception {
        Invoker hello = invokers.get("hello");
        Assert.assertEquals((String)((String)hello.invoke((Object)service, new Object[]{true, Character.valueOf('a'), 1})), (String)"foobar_true_a_1");
        Assert.assertEquals((String)((String)hello.invoke((Object)new MyService(), new Object[]{false, Character.valueOf('b'), (short)2})), (String)"foobar_false_b_2");
        Assert.assertThrows(RuntimeException.class, () -> hello.invoke((Object)new MyService(), new Object[]{null, null, null}));
        Assert.assertThrows(RuntimeException.class, () -> hello.invoke((Object)service, new Object[]{true, Character.valueOf('a'), 1L}));
        Assert.assertThrows(RuntimeException.class, () -> hello.invoke((Object)service, new Object[]{true, Character.valueOf('a'), 1.0}));
        Invoker helloStatic = invokers.get("helloStatic");
        Assert.assertEquals((String)((String)helloStatic.invoke(null, new Object[]{1L, 1.0})), (String)"quux_1_1.0");
        Assert.assertEquals((String)((String)helloStatic.invoke(null, new Object[]{1, 1.0})), (String)"quux_1_1.0");
        Assert.assertEquals((String)((String)helloStatic.invoke(null, new Object[]{1L, Float.valueOf(1.0f)})), (String)"quux_1_1.0");
        Assert.assertThrows(RuntimeException.class, () -> helloStatic.invoke(null, new Object[]{null, null}));
        Assert.assertThrows(RuntimeException.class, () -> helloStatic.invoke(null, new Object[]{1.0, 1.0}));
    }

    @ApplicationScoped
    public static class MyService {
        public String hello(boolean b, char c, int i) {
            return "foobar_" + b + "_" + c + "_" + i;
        }

        public static String helloStatic(long l, double d) {
            return "quux_" + l + "_" + d;
        }
    }

    public static class TestExtension
    extends InvokerHolderExtensionBase
    implements BuildCompatibleExtension {
        @Registration(types={MyService.class})
        public void myServiceRegistration(BeanInfo bean, InvokerFactory invokers) {
            this.registerInvokers(bean, invokers, Set.of("hello", "helloStatic"));
        }

        @Synthesis
        public void synthesis(SyntheticComponents syn) {
            this.synthesizeInvokerHolder(syn);
        }
    }
}

