/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.se.context.custom;

import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.spi.AlterableContext;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;

public class CustomRequestContext
implements AlterableContext {
    private final Map<Contextual<?>, Instance> storage = new ConcurrentHashMap();

    public void destroy(Contextual<?> contextual) {
        Instance instance = this.storage.remove(contextual);
        Contextual<?> rawContextual = contextual;
        rawContextual.destroy(instance.instance, instance.ctx);
    }

    public Class<? extends Annotation> getScope() {
        return RequestScoped.class;
    }

    public <T> T get(Contextual<T> contextual, CreationalContext<T> creationalContext) {
        T instance = this.get(contextual);
        if (instance == null) {
            this.storage.put(contextual, new Instance(contextual.create(creationalContext), creationalContext));
            instance = this.get(contextual);
        }
        return instance;
    }

    public <T> T get(Contextual<T> contextual) {
        Instance instance = this.storage.get(contextual);
        if (instance != null) {
            return (T)instance.instance;
        }
        return null;
    }

    public boolean isActive() {
        return true;
    }

    private static class Instance {
        private final Object instance;
        private final CreationalContext<?> ctx;

        public Instance(Object instance, CreationalContext<?> ctx) {
            this.instance = instance;
            this.ctx = ctx;
        }
    }
}

