/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.extensions.configurators.bean;

import java.lang.annotation.Annotation;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Inject;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.extensions.configurators.bean.Bogey;
import org.jboss.cdi.tck.tests.extensions.configurators.bean.Dangerous;
import org.jboss.cdi.tck.tests.extensions.configurators.bean.DesireToHurtHumans;
import org.jboss.cdi.tck.tests.extensions.configurators.bean.Dungeon;
import org.jboss.cdi.tck.tests.extensions.configurators.bean.Ghost;
import org.jboss.cdi.tck.tests.extensions.configurators.bean.LifecycleObserver;
import org.jboss.cdi.tck.tests.extensions.configurators.bean.MonsterController;
import org.jboss.cdi.tck.tests.extensions.configurators.bean.Skeleton;
import org.jboss.cdi.tck.tests.extensions.configurators.bean.Undead;
import org.jboss.cdi.tck.tests.extensions.configurators.bean.Vampire;
import org.jboss.cdi.tck.tests.extensions.configurators.bean.Werewolf;
import org.jboss.cdi.tck.tests.extensions.configurators.bean.Zombie;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test
@SpecVersion(spec="cdi", version="2.0")
public class BeanConfiguratorTest
extends AbstractTest {
    @Inject
    Dungeon dungeon;

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(BeanConfiguratorTest.class)).withExtension(LifecycleObserver.class)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="bean_configurator", id="aa"), @SpecAssertion(section="bean_configurator", id="ab"), @SpecAssertion(section="bean_configurator", id="f"), @SpecAssertion(section="bean_configurator", id="g"), @SpecAssertion(section="after_bean_discovery", id="de")})
    public void testCreationalAndDisposalMethods() {
        Bean<Skeleton> skeletonBean = this.getUniqueBean(Skeleton.class, Undead.UndeadLiteral.INSTANCE);
        CreationalContext skeletonCreationalContext = this.getCurrentManager().createCreationalContext(skeletonBean);
        Skeleton skeleton = (Skeleton)skeletonBean.create(skeletonCreationalContext);
        Bean<Zombie> zombieBean = this.getUniqueBean(Zombie.class, Undead.UndeadLiteral.INSTANCE, Dangerous.DangerousLiteral.INSTANCE);
        CreationalContext zombieCreationalContext = this.getCurrentManager().createCreationalContext(zombieBean);
        Zombie zombie = (Zombie)zombieBean.create(zombieCreationalContext);
        this.spawnMonster(Ghost.class, Undead.UndeadLiteral.INSTANCE);
        this.spawnMonster(Vampire.class, Undead.UndeadLiteral.INSTANCE);
        Assert.assertTrue((boolean)MonsterController.skeletonProducerCalled);
        Assert.assertTrue((boolean)MonsterController.zombieProducerCalled);
        Assert.assertTrue((boolean)MonsterController.ghostInstanceObtained);
        Assert.assertTrue((boolean)MonsterController.vampireInstanceCreated);
        skeletonBean.destroy((Object)skeleton, skeletonCreationalContext);
        zombieBean.destroy((Object)zombie, zombieCreationalContext);
        Assert.assertTrue((boolean)MonsterController.zombieKilled);
        Assert.assertTrue((boolean)MonsterController.skeletonKilled);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="bean_configurator", id="aa"), @SpecAssertion(section="bean_configurator", id="ab"), @SpecAssertion(section="bean_configurator", id="b"), @SpecAssertion(section="bean_configurator", id="c"), @SpecAssertion(section="bean_configurator", id="d"), @SpecAssertion(section="after_bean_discovery", id="de")})
    public void testInjectionPoints() {
        Assert.assertTrue((boolean)this.dungeon.hasAllMonters());
        Assert.assertTrue((this.getUniqueBean(Skeleton.class, Undead.UndeadLiteral.INSTANCE).getInjectionPoints().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((this.getUniqueBean(Zombie.class, Undead.UndeadLiteral.INSTANCE, Dangerous.DangerousLiteral.INSTANCE).getInjectionPoints().size() == 2 ? 1 : 0) != 0);
        Set ghostIP = this.getUniqueBean(Ghost.class, Undead.UndeadLiteral.INSTANCE).getInjectionPoints();
        Assert.assertTrue((ghostIP.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)((InjectionPoint)ghostIP.iterator().next()).getAnnotated().getTypeClosure().contains(DesireToHurtHumans.class));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="bean_configurator", id="ab"), @SpecAssertion(section="bean_configurator", id="e")})
    public void testPassivationCapability() {
        Assert.assertNotNull((Object)this.getCurrentManager().getPassivationCapableBean("zombie"));
    }

    @Test
    @SpecAssertion(section="bean_configurator", id="h")
    public void testDefaultScopeOfAddedBean() {
        Bean<Bogey> bogeyBean = this.getUniqueBean(Bogey.class, Undead.UndeadLiteral.INSTANCE);
        Assert.assertEquals((Object)bogeyBean.getScope(), Dependent.class);
        Bean<Werewolf> werewolfBean = this.getUniqueBean(Werewolf.class, new Annotation[0]);
        Assert.assertEquals((Object)werewolfBean.getScope(), RequestScoped.class);
    }

    @Test(dataProvider="ARQUILLIAN_DATA_PROVIDER")
    @SpecAssertions(value={@SpecAssertion(section="after_bean_discovery", id="da"), @SpecAssertion(section="process_bean", id="eca")})
    public void processSynthethicBeanEventFired(LifecycleObserver extension) {
        Assert.assertTrue((boolean)extension.isSkeletonPSBFired());
        Assert.assertTrue((boolean)extension.isVampirePSBFired());
        Assert.assertTrue((boolean)extension.isZombiePSBFired());
        Assert.assertTrue((boolean)extension.isGhostPSBFired());
    }

    private <T> void spawnMonster(Class<T> type, Annotation ... annotation) {
        Bean<T> bean = this.getUniqueBean(type, annotation);
        CreationalContext creationalContext = this.getCurrentManager().createCreationalContext(bean);
        bean.create(creationalContext);
    }
}

