/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.shrinkwrap;

import org.jboss.cdi.tck.shrinkwrap.ArchiveBuilder;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.container.LibraryContainer;
import org.jboss.shrinkwrap.api.container.ManifestContainer;
import org.jboss.shrinkwrap.api.container.ResourceContainer;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;
import org.jboss.shrinkwrap.descriptor.api.spec.se.manifest.ManifestDescriptor;
import org.jboss.shrinkwrap.descriptor.api.webapp30.WebAppDescriptor;
import org.jboss.shrinkwrap.descriptor.api.webcommon30.WebAppVersionType;

public class WebArchiveBuilder
extends ArchiveBuilder<WebArchiveBuilder, WebArchive> {
    public static final String DEFAULT_WAR_NAME = "test.war";
    private boolean hasDefaultEjbModuleDependency = false;
    private String beansDescriptorTargetBase = null;

    public WebArchiveBuilder withDefaultEjbModuleDependency() {
        this.hasDefaultEjbModuleDependency = true;
        return this;
    }

    public WebArchiveBuilder withBeansDescriptorTargetBase(String beansDescriptorTargetBase) {
        this.beansDescriptorTargetBase = beansDescriptorTargetBase;
        return this;
    }

    @Override
    public WebArchiveBuilder self() {
        return this;
    }

    @Override
    protected WebArchive buildInternal() {
        String hash;
        WebArchive webArchive = null;
        webArchive = this.getName() == null ? ((hash = this.getSha1OfTestClass()) != null ? (WebArchive)ShrinkWrap.create(WebArchive.class, (String)(hash + ".war")) : (WebArchive)ShrinkWrap.create(WebArchive.class)) : (WebArchive)ShrinkWrap.create(WebArchive.class, (String)this.getName());
        this.processPackages(webArchive);
        this.processClasses(webArchive);
        this.processLibraries((LibraryContainer<?>)webArchive);
        this.processManifestResources((ManifestContainer<?>)webArchive);
        this.processResources((ResourceContainer<?>)webArchive);
        webArchive.addAsWebInfResource(this.getBeansDescriptorAsset(), this.buildBeansDescriptorTargetPath(this.getBeansDescriptorTarget()));
        if (this.webXmlDescriptor != null) {
            webArchive.setWebXML((Asset)new StringAsset(this.webXmlDescriptor.exportAsString()));
        } else if (this.webXml != null) {
            webArchive.setWebXML(this.webXml.getSource());
        } else {
            webArchive.setWebXML((Asset)new StringAsset(((WebAppDescriptor)Descriptors.create(WebAppDescriptor.class)).version(WebAppVersionType._3_0).exportAsString()));
        }
        if (this.persistenceDescriptor != null) {
            webArchive.addAsResource((Asset)new StringAsset(this.persistenceDescriptor.exportAsString()), "META-INF/persistence.xml");
        }
        if (this.ejbJarDescriptor != null) {
            webArchive.addAsWebInfResource((Asset)new StringAsset(this.ejbJarDescriptor.exportAsString()), "ejb-jar.xml");
        } else if (this.ejbJarXml != null) {
            webArchive.addAsWebInfResource(this.ejbJarXml.getSource(), this.ejbJarXml.getTarget());
        }
        if (this.webResources != null) {
            for (ArchiveBuilder.ResourceDescriptor resource : this.webResources) {
                if (resource.getTarget() == null) {
                    webArchive.addAsWebResource(resource.getSource());
                    continue;
                }
                webArchive.addAsWebResource(resource.getSource(), resource.getTarget());
            }
        }
        if (this.hasDefaultEjbModuleDependency) {
            webArchive.setManifest((Asset)new StringAsset(((ManifestDescriptor)((ManifestDescriptor)Descriptors.create(ManifestDescriptor.class)).addToClassPath("test-ejb.jar")).exportAsString()));
        }
        return webArchive;
    }

    private String buildBeansDescriptorTargetPath(String descriptorName) {
        if (this.beansDescriptorTargetBase == null) {
            return descriptorName;
        }
        return this.beansDescriptorTargetBase + descriptorName;
    }
}

