/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.concurrent.spec.ManagedExecutorService.tx;

import ee.jakarta.tck.concurrent.framework.TestClient;
import ee.jakarta.tck.concurrent.framework.URLBuilder;
import ee.jakarta.tck.concurrent.framework.junit.anno.Assertion;
import ee.jakarta.tck.concurrent.framework.junit.anno.Common;
import ee.jakarta.tck.concurrent.framework.junit.anno.Web;
import java.net.URL;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.Order;

@Web
@RunAsClient
@Common(value={Common.PACKAGE.TRANSACTION})
public class TransactionTests
extends TestClient {
    @ArquillianResource
    private URL baseURL;

    @Deployment(name="TransactionTests")
    public static WebArchive createDeployment() {
        return (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addPackages(true, new Package[]{TransactionTests.class.getPackage()});
    }

    @Order(value=1)
    @Assertion(id="SPEC:31.3 SPEC:39.3 SPEC:92.2 SPEC:92.3", strategy="Get UserTransaction inside one task submitted by ManagedExecutorService. Test rollback function in the submitted task.")
    public void testRollbackTransactionWithManagedExecutorService() {
        this.runTest(URLBuilder.get().withBaseURL(this.baseURL).withPaths("/TransactionServlet").withQueries("isCommit=false").withTestName("transactionTest"));
    }

    @Order(value=2)
    @Assertion(id="SPEC:30 SPEC:31 SPEC:31.1 SPEC:31.2 SPEC:32 SPEC:33 SPEC:34 SPEC:36 SPEC:38 SPEC:8.1 SPEC:9 SPEC:39 SPEC:39.1 SPEC:39.2 SPEC:4.1 SPEC:4.4 SPEC:92.2 SPEC:92.3 SPEC:92.5 SPEC:41", strategy="Get UserTransaction inside one task submitted by ManagedExecutorService. It support user-managed global transaction demarcation using the jakarta.transaction.UserTransaction interface.")
    public void testCommitTransactionWithManagedExecutorService() {
        this.runTest(URLBuilder.get().withBaseURL(this.baseURL).withPaths("/TransactionServlet").withQueries("isCommit=true").withTestName("transactionTest"));
    }

    @Order(value=3)
    @Assertion(id=" SPEC:112 SPEC:35 SPEC:68 SPEC:91.4", strategy="Get UserTransaction inside one task submitted by ManagedExecutorService.cancel the task after submit one task.")
    public void testCancelTransactionWithManagedExecutorService() {
        this.runTest(URLBuilder.get().withBaseURL(this.baseURL).withPaths("/TransactionServlet").withQueries("isCommit=cancel").withTestName("cancelTest"));
    }
}

