/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.data.web.example;

import ee.jakarta.tck.data.framework.junit.anno.AnyEntity;
import ee.jakarta.tck.data.framework.junit.anno.Assertion;
import ee.jakarta.tck.data.framework.junit.anno.Web;
import ee.jakarta.tck.data.framework.servlet.TestClient;
import ee.jakarta.tck.data.framework.servlet.URLBuilder;
import ee.jakarta.tck.data.web.example.ComplexServlet;
import java.lang.reflect.Method;
import java.net.URL;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.TestInfo;

@Web
@AnyEntity
@RunAsClient
public class ComplexServletTests
extends TestClient {
    @ArquillianResource
    URL baseURL;

    @Deployment
    public static WebArchive createDeployment() {
        return (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addClass(ComplexServlet.class);
    }

    @Assertion(id="26", strategy="Run server side tests that will succeed and fail and assert the results.")
    public void testSuccessAndFailure(TestInfo testInfo) {
        URL requestURL = URLBuilder.fromURL(this.baseURL).withPath("/ComplexServlet").withQuery("testMethod", "testServletSideSuccess").build();
        super.runTest(requestURL);
        Assertions.assertThrows(AssertionError.class, () -> {
            URL requestURL2 = URLBuilder.fromURL(this.baseURL).withPath("/ComplexServlet").withQuery("testMethod", "testServletSideFailure").build();
            super.runTest(requestURL2);
        });
    }

    @Assertion(id="26", strategy="Run server side test with a method name that matches the client side test.")
    public void testMatchServletSideMethodName(TestInfo testInfo) {
        URL requestURL = URLBuilder.fromURL(this.baseURL).withPath("/ComplexServlet").withQuery("testMethod", ((Method)testInfo.getTestMethod().get()).getName()).build();
        super.runTest(requestURL);
    }

    @Assertion(id="26", strategy="Run server side test that append a unique string to the response body and make sure it is returned.")
    public void testServletSideCustomResponse(TestInfo testInfo) {
        URL requestURL = URLBuilder.fromURL(this.baseURL).withPath("/ComplexServlet").withQuery("testMethod", ((Method)testInfo.getTestMethod().get()).getName()).build();
        super.runTest(requestURL, "asdf123");
    }
}

