/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.el.api.jakarta_el.listelresolver;

import com.sun.ts.tests.el.common.api.resolver.ResolverTest;
import com.sun.ts.tests.el.common.elcontext.BareBonesELContext;
import jakarta.el.ELContext;
import jakarta.el.ELResolver;
import jakarta.el.ListELResolver;
import java.util.ArrayList;
import java.util.List;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;

public class ELClientIT {
    private static final System.Logger logger = System.getLogger(ELClientIT.class.getName());
    private List<String> names = new ArrayList<String>();

    public ELClientIT() {
        this.names.add("doug");
        this.names.add("nick");
        this.names.add("ryan");
    }

    @AfterEach
    public void cleanup() throws Exception {
        logger.log(System.Logger.Level.INFO, "Cleanup method called");
    }

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        logger.log(System.Logger.Level.INFO, "STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        logger.log(System.Logger.Level.INFO, "FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Test
    public void listELResolverTest() throws Exception {
        boolean pass = false;
        StringBuffer buf = new StringBuffer();
        try {
            ListELResolver listResolver = new ListELResolver();
            BareBonesELContext barebonesContext = new BareBonesELContext();
            ELContext context = barebonesContext.getELContext();
            pass = ResolverTest.testELResolver(context, (ELResolver)listResolver, this.names, 1, "ed", buf, false);
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
        if (!pass) {
            throw new Exception("Test FAILED" + buf.toString());
        }
        logger.log(System.Logger.Level.TRACE, buf.toString());
    }

    @Test
    public void listELResolverNPETest() throws Exception {
        boolean pass = false;
        StringBuffer buf = new StringBuffer();
        ListELResolver resolver = new ListELResolver();
        try {
            pass = ResolverTest.testELResolverNPE((ELResolver)resolver, this.names, 1, "billy", buf);
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
        if (!pass) {
            throw new Exception("Test FAILED" + buf.toString());
        }
        logger.log(System.Logger.Level.TRACE, buf.toString());
    }

    @Test
    public void listELResolverPNFETest() throws Exception {
        boolean pass = false;
        StringBuffer buf = new StringBuffer();
        ListELResolver resolver = new ListELResolver();
        BareBonesELContext barebonesComtext = new BareBonesELContext();
        ELContext context = barebonesComtext.getELContext();
        try {
            pass = ResolverTest.testELResolverPNFE(context, (ELResolver)resolver, this.names, 10, buf);
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
        if (!pass) {
            throw new Exception("Test FAILED" + buf.toString());
        }
        logger.log(System.Logger.Level.TRACE, buf.toString());
    }

    @Test
    public void listELResolverIAETest() throws Exception {
        boolean pass = false;
        StringBuffer buf = new StringBuffer();
        ListELResolver resolver = new ListELResolver();
        BareBonesELContext barebonesComtext = new BareBonesELContext();
        ELContext context = barebonesComtext.getELContext();
        try {
            pass = ResolverTest.testELResolverIAE(context, (ELResolver)resolver, this.names, "GARBAGE", "billy", buf);
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
        if (!pass) {
            throw new Exception("Test FAILED" + buf.toString());
        }
        logger.log(System.Logger.Level.TRACE, buf.toString());
    }

    @Test
    public void listELResolverPNWETest() throws Exception {
        boolean pass = false;
        StringBuffer buf = new StringBuffer();
        ListELResolver resolver = new ListELResolver(true);
        BareBonesELContext barebonesComtext = new BareBonesELContext();
        ELContext context = barebonesComtext.getELContext();
        try {
            pass = ResolverTest.testELResolverPNWE(context, (ELResolver)resolver, this.names, 1, "billy", buf);
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
        if (!pass) {
            throw new Exception("Test FAILED" + buf.toString());
        }
        logger.log(System.Logger.Level.TRACE, buf.toString());
    }
}

