/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.el.common.elresolver;

import jakarta.el.ELContext;
import jakarta.el.ELResolver;
import java.util.Set;

public class SingleIdentifierELResolver
extends ELResolver {
    public static final String SINGLE = "single";
    public static final String NOT_SINGLE = "notSingle";
    private static final Set<String> IDENTIFIERS = Set.of("single", "notSingle");
    public static final String FAIL = "NOT_OK";
    public static final String PASS = "OK";

    public Object getValue(ELContext context, Object base, Object property) {
        if (!this.willResolve(context, base, property)) {
            return null;
        }
        Object marker = context.getContext(ELResolver.StandaloneIdentifierMarker.class);
        if (marker == null) {
            if (NOT_SINGLE.equals(property)) {
                return PASS;
            }
            return FAIL;
        }
        if (!(marker instanceof Boolean)) {
            return FAIL;
        }
        Boolean b = (Boolean)marker;
        if (SINGLE.equals(property)) {
            if (b.booleanValue()) {
                return PASS;
            }
            return FAIL;
        }
        if (NOT_SINGLE.equals(property)) {
            if (b.booleanValue()) {
                return FAIL;
            }
            return PASS;
        }
        return FAIL;
    }

    public Class<?> getType(ELContext context, Object base, Object property) {
        if (!this.willResolve(context, base, property)) {
            return null;
        }
        return String.class;
    }

    public void setValue(ELContext context, Object base, Object property, Object value) {
    }

    public boolean isReadOnly(ELContext context, Object base, Object property) {
        return this.willResolve(context, base, property);
    }

    public Class<?> getCommonPropertyType(ELContext context, Object base) {
        return String.class;
    }

    private boolean willResolve(ELContext context, Object base, Object property) {
        if (base == null && IDENTIFIERS.contains(property)) {
            context.setPropertyResolved(true);
            return true;
        }
        return false;
    }
}

