/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.admin;

import com.sun.enterprise.config.serverbeans.AppTenant;
import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.deploy.shared.ArchiveFactory;
import com.sun.enterprise.util.LocalStringManagerImpl;
import jakarta.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AccessRequired;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.AdminCommandSecurity;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.deployment.OpsParams;
import org.glassfish.api.deployment.UndeployCommandParameters;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.deployment.common.DeploymentUtils;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.internal.data.ApplicationInfo;
import org.glassfish.internal.deployment.Deployment;
import org.glassfish.internal.deployment.ExtendedDeploymentContext;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;

@Service(name="_mt-unprovision")
@ExecuteOn(value={RuntimeType.DAS})
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
public class MTUnprovisionCommand
implements AdminCommand,
AdminCommandSecurity.AccessCheckProvider {
    @Param(primary=true)
    public String appname = null;
    @Param
    public String tenant = null;
    @Inject
    Applications applications;
    @Inject
    Deployment deployment;
    @Inject
    ArchiveFactory archiveFactory;
    private Application app;
    private AppTenant appTenant = null;
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(MTUnprovisionCommand.class);

    public Collection<? extends AccessRequired.AccessCheck> getAccessChecks() {
        ArrayList<AccessRequired.AccessCheck> accessChecks = new ArrayList<AccessRequired.AccessCheck>();
        this.app = this.applications.getApplication(this.appname);
        if (this.app != null) {
            accessChecks.add(new AccessRequired.AccessCheck(AccessRequired.Util.resourceNameFromConfigBeanProxy((ConfigBeanProxy)this.app), "read"));
            if (this.app.getAppTenants() != null) {
                this.appTenant = this.app.getAppTenants().getAppTenant(this.tenant);
                if (this.appTenant != null) {
                    accessChecks.add(new AccessRequired.AccessCheck(AccessRequired.Util.resourceNameFromConfigBeanProxy((ConfigBeanProxy)this.appTenant), "unprovision"));
                }
            }
        }
        return accessChecks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        Logger logger = context.getLogger();
        if (this.app == null) {
            report.setMessage("Application " + this.appname + " is not deployed");
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        if (this.appTenant == null) {
            report.setMessage("Application " + this.appname + " is not provisioned to tenant " + this.tenant);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        String internalAppName = DeploymentUtils.getInternalNameForTenant((String)this.appname, (String)this.tenant);
        ApplicationInfo appInfo = this.deployment.get(internalAppName);
        ReadableArchive archive = null;
        try {
            if (appInfo != null) {
                archive = appInfo.getSource();
            } else {
                URI uri = new URI(this.app.getLocation());
                File location = new File(uri);
                if (location.exists()) {
                    archive = this.archiveFactory.openArchive(location);
                } else {
                    logger.log(Level.WARNING, localStrings.getLocalString("fnf", "File not found", new Object[]{location.getAbsolutePath()}));
                    this.deployment.unregisterTenantWithAppInDomainXML(this.appname, this.tenant);
                    return;
                }
            }
            UndeployCommandParameters commandParams = new UndeployCommandParameters();
            commandParams.target = "server";
            commandParams.name = internalAppName;
            commandParams.origin = OpsParams.Origin.mt_unprovision;
            ExtendedDeploymentContext deploymentContext = this.deployment.getBuilder(logger, (OpsParams)commandParams, report).source(archive).build();
            deploymentContext.getAppProps().putAll((Map<?, ?>)this.app.getDeployProperties());
            deploymentContext.getAppProps().putAll((Map<?, ?>)this.appTenant.getDeployProperties());
            deploymentContext.setModulePropsMap(this.app.getModulePropertiesMap());
            deploymentContext.setTenant(this.tenant, this.app.getName());
            this.deployment.undeploy(internalAppName, deploymentContext);
            this.deployment.unregisterTenantWithAppInDomainXML(this.appname, this.tenant);
            deploymentContext.clean();
        }
        catch (Throwable e) {
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(e.getMessage());
            report.setFailureCause(e);
        }
        finally {
            try {
                if (archive != null) {
                    archive.close();
                }
            }
            catch (IOException iOException) {}
        }
    }
}

