/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.impl.filter;

import com.sun.xml.ws.security.IssuedTokenContext;
import com.sun.xml.ws.security.opt.api.SecurityHeaderElement;
import com.sun.xml.ws.security.opt.impl.JAXBFilterProcessingContext;
import com.sun.xml.ws.security.opt.impl.crypto.SSEData;
import com.sun.xml.ws.security.opt.impl.keyinfo.SecurityTokenReference;
import com.sun.xml.ws.security.opt.impl.keyinfo.X509TokenBuilder;
import com.sun.xml.ws.security.opt.impl.message.GSHeaderElement;
import com.sun.xml.ws.security.opt.impl.outgoing.SecurityHeader;
import com.sun.xml.ws.security.opt.impl.reference.KeyIdentifier;
import com.sun.xml.ws.security.opt.impl.tokens.UsernameToken;
import com.sun.xml.ws.security.opt.impl.util.NamespaceContextEx;
import com.sun.xml.ws.security.opt.impl.util.WSSElementFactory;
import com.sun.xml.ws.security.trust.GenericToken;
import com.sun.xml.wss.NonceManager;
import com.sun.xml.wss.ProcessingContext;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.impl.FilterProcessingContext;
import com.sun.xml.wss.impl.HarnessUtil;
import com.sun.xml.wss.impl.MessageConstants;
import com.sun.xml.wss.impl.SecurableSoapMessage;
import com.sun.xml.wss.impl.XMLUtil;
import com.sun.xml.wss.impl.callback.DynamicPolicyCallback;
import com.sun.xml.wss.impl.configuration.DynamicApplicationContext;
import com.sun.xml.wss.impl.filter.ExportSamlAssertionFilter;
import com.sun.xml.wss.impl.filter.ImportSamlAssertionFilter;
import com.sun.xml.wss.impl.keyinfo.KeyIdentifierStrategy;
import com.sun.xml.wss.impl.misc.DefaultSecurityEnvironmentImpl;
import com.sun.xml.wss.impl.misc.SecurityUtil;
import com.sun.xml.wss.impl.policy.mls.AuthenticationTokenPolicy;
import com.sun.xml.wss.impl.policy.mls.IssuedTokenKeyBinding;
import com.sun.xml.wss.impl.policy.mls.KeyBindingBase;
import com.sun.xml.wss.impl.policy.mls.TimestampPolicy;
import com.sun.xml.wss.logging.impl.filter.LogStringsMessages;
import jakarta.xml.soap.SOAPElement;
import jakarta.xml.soap.SOAPPart;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class AuthenticationTokenFilter {
    private static final Logger log = Logger.getLogger("com.sun.xml.wss.logging.impl.filter", "com.sun.xml.wss.logging.impl.filter.LogStrings");

    public static void processUserNameToken(FilterProcessingContext context) throws XWSSecurityException {
        if (context.isInboundMessage()) {
            AuthenticationTokenFilter.getUserNameTokenFromMessage(context);
        } else {
            AuthenticationTokenFilter.addUserNameTokenToMessage(context);
        }
    }

    public static void processSamlToken(FilterProcessingContext context) throws XWSSecurityException {
        if (context.isInboundMessage()) {
            ImportSamlAssertionFilter.process(context);
        } else {
            ExportSamlAssertionFilter.process(context);
        }
    }

    public static void processIssuedToken(FilterProcessingContext context) throws XWSSecurityException {
        if (!context.isInboundMessage()) {
            AuthenticationTokenFilter.addIssuedTokenToMessage(context);
        }
    }

    private static void getUserNameTokenFromMessage(FilterProcessingContext context) throws XWSSecurityException {
        String password;
        String username;
        block30: {
            SecurableSoapMessage secureMessage = context.getSecurableSoapMessage();
            com.sun.xml.wss.core.SecurityHeader wsseSecurity = secureMessage.findSecurityHeader();
            com.sun.xml.wss.core.UsernameToken token = null;
            if (context.getMode() == 0) {
                AuthenticationTokenPolicy policy;
                if (context.makeDynamicPolicyCallback()) {
                    try {
                        policy = (AuthenticationTokenPolicy)context.getSecurityPolicy();
                        AuthenticationTokenPolicy.UsernameTokenBinding userNamePolicy = (AuthenticationTokenPolicy.UsernameTokenBinding)policy.getFeatureBinding();
                        userNamePolicy.isReadOnly(true);
                        DynamicApplicationContext dynamicContext = new DynamicApplicationContext(context.getPolicyContext());
                        dynamicContext.setMessageIdentifier(context.getMessageIdentifier());
                        dynamicContext.inBoundMessage(true);
                        DynamicPolicyCallback dynamicCallback = new DynamicPolicyCallback(userNamePolicy, dynamicContext);
                        ProcessingContext.copy(dynamicContext.getRuntimeProperties(), context.getExtraneousProperties());
                        HarnessUtil.makeDynamicPolicyCallback(dynamicCallback, context.getSecurityEnvironment().getCallbackHandler());
                        policy.setFeatureBinding((AuthenticationTokenPolicy.UsernameTokenBinding)dynamicCallback.getSecurityPolicy());
                    }
                    catch (Exception e) {
                        log.log(Level.SEVERE, LogStringsMessages.WSS_1427_ERROR_ADHOC(), e);
                        throw new XWSSecurityException(e);
                    }
                }
                policy = (AuthenticationTokenPolicy)context.getSecurityPolicy();
                NodeList nodeList = wsseSecurity.getElementsByTagNameNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "UsernameToken");
                if (nodeList.getLength() <= 0) {
                    log.log(Level.SEVERE, LogStringsMessages.WSS_1400_NOUSERNAME_FOUND());
                    throw new XWSSecurityException("No Username token found ,Receiver requirement not met");
                }
                if (nodeList.getLength() > 1) {
                    log.log(Level.SEVERE, LogStringsMessages.WSS_1401_MORETHANONE_USERNAME_FOUND());
                    throw new XWSSecurityException("More than one Username token found, Receiver requirement not met");
                }
                SOAPElement userNameTokenElement = (SOAPElement)nodeList.item(0);
                token = new com.sun.xml.wss.core.UsernameToken(userNameTokenElement, policy.isBSP());
                token.isBSP(policy.isBSP());
            } else {
                if (context.getMode() == 1) {
                    log.log(Level.SEVERE, LogStringsMessages.WSS_1402_ERROR_POSTHOC());
                    throw new XWSSecurityException("Internal Error: Called UsernameTokenFilter in POSTHOC Mode");
                }
                try {
                    token = new com.sun.xml.wss.core.UsernameToken(wsseSecurity.getCurrentHeaderElement());
                }
                catch (XWSSecurityException ex) {
                    log.log(Level.SEVERE, LogStringsMessages.WSS_1403_IMPORT_USERNAME_TOKEN(), ex);
                    throw SecurableSoapMessage.newSOAPFaultException(MessageConstants.WSSE_INVALID_SECURITY_TOKEN, "Exception while importing Username Password Token", ex);
                }
            }
            username = token.getUsername();
            password = token.getPassword();
            String passwordDigest = token.getPasswordDigest();
            String passwordType = token.getPasswordType();
            String nonce = token.getNonce();
            String created = token.getCreated();
            boolean authenticated = false;
            if (context.getMode() == 0) {
                AuthenticationTokenPolicy policy = (AuthenticationTokenPolicy)context.getSecurityPolicy();
                AuthenticationTokenPolicy.UsernameTokenBinding utBinding = (AuthenticationTokenPolicy.UsernameTokenBinding)policy.getFeatureBinding();
                if (utBinding.getDigestOn() && passwordDigest == null) {
                    log.log(Level.SEVERE, LogStringsMessages.WSS_1404_NOTMET_DIGESTED());
                    throw new XWSSecurityException("Receiver Requirement for Digested Password has not been met");
                }
                if (!utBinding.getDigestOn() && passwordDigest != null) {
                    log.log(Level.SEVERE, LogStringsMessages.WSS_1405_NOTMET_PLAINTEXT());
                    throw new XWSSecurityException("Receiver Requirement for Plain-Text Password has not been met, Received token has Password-Digest");
                }
                if (utBinding.getUseNonce() && nonce == null) {
                    log.log(Level.SEVERE, LogStringsMessages.WSS_1406_NOTMET_NONCE());
                    throw new XWSSecurityException("Receiver Requirement for nonce has not been met");
                }
                if (!utBinding.getUseNonce() && nonce != null) {
                    log.log(Level.SEVERE, LogStringsMessages.WSS_1407_NOTMET_NONONCE());
                    throw new XWSSecurityException("Receiver Requirement for no nonce has not been met, Received token has a nonce specified");
                }
            } else if (context.getMode() == 3) {
                AuthenticationTokenPolicy.UsernameTokenBinding sp = new AuthenticationTokenPolicy.UsernameTokenBinding();
                if (passwordDigest != null) {
                    sp.setDigestOn(true);
                }
                if (nonce != null) {
                    sp.setUseNonce(true);
                }
                context.getInferredSecurityPolicy().append(sp);
            }
            try {
                authenticated = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText" == passwordType ? context.getSecurityEnvironment().authenticateUser(context.getExtraneousProperties(), username, password) : context.getSecurityEnvironment().authenticateUser(context.getExtraneousProperties(), username, passwordDigest, nonce, created);
                if (!authenticated) {
                    log.log(Level.SEVERE, LogStringsMessages.WSS_1408_FAILED_SENDER_AUTHENTICATION());
                    XWSSecurityException xwse = new XWSSecurityException("Invalid Username Password Pair");
                    throw SecurableSoapMessage.newSOAPFaultException(MessageConstants.WSSE_FAILED_AUTHENTICATION, "Authentication of Username Password Token Failed", xwse);
                }
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "Password Validated.....");
                }
                long maxClockSkew = 300000L;
                long freshnessLmt = 300000L;
                long maxNonceAge = 900000L;
                if (context.getMode() == 0) {
                    AuthenticationTokenPolicy authPolicy = (AuthenticationTokenPolicy)context.getSecurityPolicy();
                    AuthenticationTokenPolicy.UsernameTokenBinding policy = (AuthenticationTokenPolicy.UsernameTokenBinding)authPolicy.getFeatureBinding();
                    if (created != null) {
                        TimestampPolicy tPolicy = (TimestampPolicy)policy.getFeatureBinding();
                        maxClockSkew = tPolicy.getMaxClockSkew();
                        freshnessLmt = tPolicy.getTimestampFreshness();
                    }
                    maxNonceAge = policy.getMaxNonceAge();
                }
                if (created != null) {
                    context.getSecurityEnvironment().validateCreationTime(context.getExtraneousProperties(), created, maxClockSkew, freshnessLmt);
                }
                if (log.isLoggable(Level.FINEST) && created != null) {
                    log.log(Level.FINEST, "CreationTime Validated.....");
                }
                if (nonce == null) break block30;
                try {
                    if (!context.getSecurityEnvironment().validateAndCacheNonce(context.getExtraneousProperties(), nonce, created, maxNonceAge)) {
                        XWSSecurityException xwse = new XWSSecurityException("Invalid/Repeated Nonce value for Username Token");
                        log.log(Level.SEVERE, LogStringsMessages.WSS_1406_NOTMET_NONCE(), xwse);
                        throw DefaultSecurityEnvironmentImpl.newSOAPFaultException(MessageConstants.WSSE_FAILED_AUTHENTICATION, "Invalid/Repeated Nonce value for Username Token", xwse);
                    }
                }
                catch (NonceManager.NonceException ex) {
                    log.log(Level.SEVERE, LogStringsMessages.WSS_1406_NOTMET_NONCE(), ex);
                    throw SecurableSoapMessage.newSOAPFaultException(MessageConstants.WSSE_FAILED_AUTHENTICATION, "Invalid/Repeated Nonce value for Username Token", ex);
                }
            }
            catch (XWSSecurityException xwsse) {
                log.log(Level.SEVERE, LogStringsMessages.WSS_1408_FAILED_SENDER_AUTHENTICATION(), xwsse);
                throw SecurableSoapMessage.newSOAPFaultException(MessageConstants.WSSE_FAILED_AUTHENTICATION, xwsse.getMessage(), xwsse);
            }
        }
        context.getSecurityEnvironment().updateOtherPartySubject(DefaultSecurityEnvironmentImpl.getSubject(context), username, password);
    }

    public static AuthenticationTokenPolicy.UsernameTokenBinding resolveUserNameTokenData(FilterProcessingContext context, com.sun.xml.wss.core.UsernameToken token, UsernameToken unToken, AuthenticationTokenPolicy policy) throws XWSSecurityException {
        if (!context.makeDynamicPolicyCallback()) {
            AuthenticationTokenPolicy.UsernameTokenBinding userNamePolicy = (AuthenticationTokenPolicy.UsernameTokenBinding)policy.getFeatureBinding();
            String userName = userNamePolicy.getUsername();
            String password = userNamePolicy.getPassword();
            if (userName == null || "".equals(userName)) {
                userName = context.getSecurityEnvironment().getUsername(context.getExtraneousProperties());
            }
            if (userName == null || "".equals(userName)) {
                log.log(Level.SEVERE, LogStringsMessages.WSS_1409_INVALID_USERNAME_TOKEN());
                throw new XWSSecurityException("Username has not been set");
            }
            if (token != null) {
                token.setUsername(userName);
            } else {
                unToken.setUsernameValue(userName);
            }
            if (!userNamePolicy.hasNoPassword() && (password == null || "".equals(password))) {
                password = context.getSecurityEnvironment().getPassword(context.getExtraneousProperties());
            }
            if (!userNamePolicy.hasNoPassword()) {
                if (password == null) {
                    log.log(Level.SEVERE, LogStringsMessages.WSS_1424_INVALID_USERNAME_TOKEN());
                    throw new XWSSecurityException("Password for the username has not been set");
                }
                if (token != null) {
                    token.setPassword(password);
                } else {
                    unToken.setPasswordValue(password);
                }
            }
            return userNamePolicy;
        }
        try {
            AuthenticationTokenPolicy.UsernameTokenBinding userNamePolicy = (AuthenticationTokenPolicy.UsernameTokenBinding)policy.getFeatureBinding();
            userNamePolicy.isReadOnly(true);
            DynamicApplicationContext dynamicContext = new DynamicApplicationContext(context.getPolicyContext());
            dynamicContext.setMessageIdentifier(context.getMessageIdentifier());
            dynamicContext.inBoundMessage(false);
            DynamicPolicyCallback dynamicCallback = new DynamicPolicyCallback(userNamePolicy, dynamicContext);
            ProcessingContext.copy(dynamicContext.getRuntimeProperties(), context.getExtraneousProperties());
            HarnessUtil.makeDynamicPolicyCallback(dynamicCallback, context.getSecurityEnvironment().getCallbackHandler());
            AuthenticationTokenPolicy.UsernameTokenBinding resolvedPolicy = (AuthenticationTokenPolicy.UsernameTokenBinding)dynamicCallback.getSecurityPolicy();
            if (token != null) {
                token.setUsername(resolvedPolicy.getUsername());
                token.setPassword(resolvedPolicy.getPassword());
            } else {
                unToken.setUsernameValue(resolvedPolicy.getUsername());
                unToken.setPasswordValue(resolvedPolicy.getPassword());
            }
            return resolvedPolicy;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, LogStringsMessages.WSS_1403_IMPORT_USERNAME_TOKEN(), e);
            throw new XWSSecurityException(e);
        }
    }

    public static void addUserNameTokenToMessage(FilterProcessingContext context) throws XWSSecurityException {
        if (context instanceof JAXBFilterProcessingContext) {
            String wsuId;
            TimestampPolicy tPolicy;
            String creationTime;
            JAXBFilterProcessingContext opContext = (JAXBFilterProcessingContext)context;
            SecurityHeader secHeader = opContext.getSecurityHeader();
            AuthenticationTokenPolicy authPolicy = (AuthenticationTokenPolicy)context.getSecurityPolicy();
            UsernameToken unToken = new UsernameToken(opContext.getSOAPVersion());
            AuthenticationTokenPolicy.UsernameTokenBinding policy = AuthenticationTokenFilter.resolveUserNameTokenData(opContext, null, unToken, authPolicy);
            if (policy.getUseNonce()) {
                unToken.setNonce(policy.getNonce());
            }
            if (policy.getDigestOn()) {
                unToken.setDigestOn();
            }
            if (policy.getUseNonce() || policy.getDigestOn() || policy.getUseCreated()) {
                creationTime = "";
                tPolicy = (TimestampPolicy)policy.getFeatureBinding();
                creationTime = tPolicy.getCreationTime();
                unToken.setCreationTime(creationTime);
            }
            if (policy.hasNoPassword()) {
                creationTime = "";
                tPolicy = (TimestampPolicy)policy.getFeatureBinding();
                creationTime = tPolicy.getCreationTime();
                unToken.setCreationTime(creationTime);
            }
            if ((wsuId = policy.getUUID()) != null && !wsuId.equals("")) {
                unToken.setId(wsuId);
            }
            secHeader.add(unToken);
        } else {
            TimestampPolicy tPolicy;
            String creationTime;
            AuthenticationTokenPolicy authPolicy;
            SecurableSoapMessage secureMessage = context.getSecurableSoapMessage();
            SOAPPart soapPart = secureMessage.getSOAPPart();
            com.sun.xml.wss.core.UsernameToken token = new com.sun.xml.wss.core.UsernameToken((Document)soapPart, "");
            AuthenticationTokenPolicy.UsernameTokenBinding policy = AuthenticationTokenFilter.resolveUserNameTokenData(context, token, null, authPolicy = (AuthenticationTokenPolicy)context.getSecurityPolicy());
            if (policy.getUseNonce()) {
                token.setNonce(policy.getNonce());
            }
            if (policy.getDigestOn()) {
                token.setDigestOn();
            }
            if (policy.getUseNonce() || policy.getDigestOn() || policy.getUseCreated()) {
                creationTime = "";
                tPolicy = (TimestampPolicy)policy.getFeatureBinding();
                creationTime = tPolicy.getCreationTime();
                token.setCreationTime(creationTime);
            }
            if (policy.hasNoPassword()) {
                creationTime = "";
                tPolicy = (TimestampPolicy)policy.getFeatureBinding();
                creationTime = tPolicy.getCreationTime();
                token.setCreationTime(creationTime);
            }
            com.sun.xml.wss.core.SecurityHeader wsseSecurity = secureMessage.findOrCreateSecurityHeader();
            String wsuId = policy.getUUID();
            if (wsuId != null && !wsuId.equals("")) {
                XMLUtil.setWsuIdAttr((Element)token.getAsSoapElement(), wsuId);
            }
            wsseSecurity.insertHeaderBlock(token);
        }
    }

    public static void addIssuedTokenToMessage(FilterProcessingContext context) throws XWSSecurityException {
        boolean includeToken;
        AuthenticationTokenPolicy authPolicy = (AuthenticationTokenPolicy)context.getSecurityPolicy();
        IssuedTokenKeyBinding itkb = (IssuedTokenKeyBinding)authPolicy.getFeatureBinding();
        String itType = itkb.getIncludeToken();
        boolean bl = includeToken = KeyBindingBase.INCLUDE_ALWAYS_TO_RECIPIENT.equals(itType) || KeyBindingBase.INCLUDE_ALWAYS.equals(itType) || KeyBindingBase.INCLUDE_ALWAYS_VER2.equals(itType) || KeyBindingBase.INCLUDE_ALWAYS_TO_RECIPIENT_VER2.equals(itType);
        if (context instanceof JAXBFilterProcessingContext) {
            String itPolicyId;
            IssuedTokenContext ictx;
            JAXBFilterProcessingContext opContext = (JAXBFilterProcessingContext)context;
            SecurityHeader secHeader = opContext.getSecurityHeader();
            SecurityHeaderElement issuedTokenElement = null;
            GenericToken issuedToken = null;
            if (opContext.getTrustContext() == null && (ictx = opContext.getIssuedTokenContext(itPolicyId = itkb.getUUID())) != null) {
                opContext.setTrustContext(ictx);
                issuedToken = (GenericToken)ictx.getSecurityToken();
            }
            if (issuedToken != null && (issuedTokenElement = issuedToken.getElement()) == null) {
                Element element = (Element)issuedToken.getTokenValue();
                issuedTokenElement = new GSHeaderElement(element);
                issuedTokenElement.setId(issuedToken.getId());
            }
            if (issuedToken != null && includeToken && opContext.getSecurityHeader().getChildElement(issuedTokenElement.getId()) == null) {
                secHeader.add(issuedTokenElement);
            }
            if (null != itkb.getSTRID()) {
                String itId = issuedToken.getId();
                WSSElementFactory elementFactory = new WSSElementFactory(opContext.getSOAPVersion());
                KeyIdentifier ref = elementFactory.createKeyIdentifier();
                ref.setValue(itId);
                String valueType = null;
                if (issuedTokenElement != null) {
                    String issuedTokenNS = issuedTokenElement.getNamespaceURI();
                    if ("urn:oasis:names:tc:SAML:1.0:assertion".equals(issuedTokenNS)) {
                        valueType = "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID";
                    }
                    if ("urn:oasis:names:tc:SAML:2.0:assertion".equals(issuedTokenNS)) {
                        valueType = "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLID";
                    }
                }
                ref.setValueType(valueType);
                SecurityTokenReference secTokRef = elementFactory.createSecurityTokenReference(ref);
                String strId = itkb.getSTRID();
                secTokRef.setId(strId);
                SSEData data = new SSEData(issuedTokenElement, false, opContext.getNamespaceContext());
                opContext.getElementCache().put(strId, data);
                secHeader.add(secTokRef);
            }
        } else {
            Element element;
            SOAPElement tokenEle;
            String itPolicyId;
            IssuedTokenContext ictx;
            SecurableSoapMessage secureMessage = context.getSecurableSoapMessage();
            SOAPPart soapPart = secureMessage.getSOAPPart();
            GenericToken issuedToken = null;
            if (context.getTrustContext() == null && (ictx = context.getIssuedTokenContext(itPolicyId = itkb.getUUID())) != null) {
                context.setTrustContext(ictx);
                issuedToken = (GenericToken)ictx.getSecurityToken();
            }
            if ((tokenEle = XMLUtil.convertToSoapElement((Document)soapPart, element = (Element)issuedToken.getTokenValue())) != null && includeToken) {
                secureMessage.findOrCreateSecurityHeader().insertHeaderBlockElement(tokenEle);
            }
            context.setIssuedSAMLToken((Element)tokenEle);
            if (null != itkb.getSTRID()) {
                String itId = issuedToken.getId();
                com.sun.xml.wss.core.SecurityTokenReference tokenRef = new com.sun.xml.wss.core.SecurityTokenReference((Document)secureMessage.getSOAPPart());
                tokenRef.setWsuId(itkb.getSTRID());
                KeyIdentifierStrategy strat = new KeyIdentifierStrategy(itId);
                strat.insertKey(tokenRef, context.getSecurableSoapMessage());
                secureMessage.findOrCreateSecurityHeader().insertHeaderBlock(tokenRef);
            }
        }
    }

    public static void processX509Token(FilterProcessingContext context) throws XWSSecurityException {
        if (context.isInboundMessage()) {
            return;
        }
        AuthenticationTokenPolicy authPolicy = (AuthenticationTokenPolicy)context.getSecurityPolicy();
        AuthenticationTokenPolicy.X509CertificateBinding policy = (AuthenticationTokenPolicy.X509CertificateBinding)authPolicy.getFeatureBinding();
        X509Certificate cert = context.getSecurityEnvironment().getDefaultCertificate(context.getExtraneousProperties());
        if (cert == null) {
            throw new XWSSecurityException("No default X509 certificate was provided");
        }
        AuthenticationTokenPolicy.X509CertificateBinding policyClone = (AuthenticationTokenPolicy.X509CertificateBinding)policy.clone();
        policyClone.setX509Certificate(cert);
        if (context instanceof JAXBFilterProcessingContext) {
            JAXBFilterProcessingContext opContext = (JAXBFilterProcessingContext)context;
            ((NamespaceContextEx)opContext.getNamespaceContext()).addWSSNS();
            X509TokenBuilder x509TokenBuilder = new X509TokenBuilder(opContext, policyClone);
            x509TokenBuilder.process();
        } else {
            SecurableSoapMessage secureMessage = context.getSecurableSoapMessage();
            String wsuId = policy.getUUID();
            if (wsuId == null) {
                wsuId = secureMessage.generateId();
            }
            SecurityUtil.checkIncludeTokenPolicy(context, policyClone, wsuId);
        }
    }

    public static void processRSAToken(FilterProcessingContext context) {
        if (context.isInboundMessage()) {
            // empty if block
        }
    }
}

