/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.adapter;

import com.sun.enterprise.v3.common.PropsFileActionReporter;
import jakarta.inject.Inject;
import jakarta.ws.rs.core.Application;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Level;
import javax.security.auth.Subject;
import org.glassfish.admin.rest.RestLogging;
import org.glassfish.admin.rest.adapter.AdminJerseyServiceIteratorProvider;
import org.glassfish.admin.rest.adapter.JerseyContainer;
import org.glassfish.admin.rest.adapter.RestAdapter;
import org.glassfish.admin.rest.adapter.RestCommandResourceProvider;
import org.glassfish.api.ActionReport;
import org.glassfish.api.StartupRunLevel;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.container.EndpointRegistrationException;
import org.glassfish.grizzly.http.server.HttpHandler;
import org.glassfish.grizzly.http.server.Request;
import org.glassfish.grizzly.http.server.Response;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.api.TypeLiteral;
import org.glassfish.hk2.extras.ExtrasUtilities;
import org.glassfish.hk2.utilities.Binder;
import org.glassfish.hk2.utilities.binding.AbstractBinder;
import org.glassfish.internal.api.InternalSystemAdministrator;
import org.glassfish.internal.api.ServerContext;
import org.glassfish.jersey.grizzly2.httpserver.GrizzlyHttpContainer;
import org.glassfish.jersey.inject.hk2.Hk2ReferencingFactory;
import org.glassfish.jersey.internal.ServiceFinder;
import org.glassfish.jersey.internal.util.collection.Ref;
import org.glassfish.jersey.process.internal.RequestScoped;
import org.glassfish.jersey.server.ContainerFactory;
import org.glassfish.jersey.server.ResourceConfig;
import org.jvnet.hk2.annotations.Service;

@Service
@StartupRunLevel
public class JerseyContainerCommandService
implements PostConstruct {
    @Inject
    private ServiceLocator serviceLocator;
    @Inject
    private InternalSystemAdministrator kernelIdentity;
    private Future<JerseyContainer> future;

    @Override
    public void postConstruct() {
        if (Boolean.parseBoolean(System.getenv("AS_INIT_REST_EAGER"))) {
            ExecutorService executor = Executors.newFixedThreadPool(8);
            this.future = executor.submit(() -> {
                JerseyContainer result = this.exposeContext();
                return result;
            });
            executor.execute(() -> {
                CommandRunner cr = this.serviceLocator.getService(CommandRunner.class, new Annotation[0]);
                CommandRunner.CommandInvocation invocation = cr.getCommandInvocation("uptime", (ActionReport)new PropsFileActionReporter(), this.kernelIdentity.getSubject());
                invocation.parameters(new ParameterMap());
                invocation.execute();
            });
            executor.shutdown();
        }
    }

    public JerseyContainer getJerseyContainer() throws EndpointRegistrationException {
        try {
            if (this.future == null) {
                return this.exposeContext();
            }
            return this.future.get();
        }
        catch (InterruptedException ex) {
            return this.exposeContext();
        }
        catch (ExecutionException ex) {
            Throwable orig = ex.getCause();
            if (orig instanceof EndpointRegistrationException) {
                throw (EndpointRegistrationException)orig;
            }
            RestLogging.restLogger.log(Level.SEVERE, "NCLS-REST-00015", orig);
            return null;
        }
    }

    private ServerContext getServerContext() {
        return this.serviceLocator.getService(ServerContext.class, new Annotation[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JerseyContainer exposeContext() throws EndpointRegistrationException {
        Set<Class<?>> classes = RestCommandResourceProvider.getResourceClasses();
        ClassLoader originalContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            ServerContext serverContext = this.getServerContext();
            ClassLoader apiClassLoader = serverContext.getCommonClassLoader();
            Thread.currentThread().setContextClassLoader(apiClassLoader);
            ResourceConfig rc = new RestCommandResourceProvider().getResourceConfig(classes, serverContext, this.serviceLocator, this.getAdditionalBinders());
            JerseyContainer jerseyContainer = this.getJerseyContainer(rc);
            return jerseyContainer;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalContextClassLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JerseyContainer getJerseyContainer(ResourceConfig config) {
        AdminJerseyServiceIteratorProvider iteratorProvider = new AdminJerseyServiceIteratorProvider();
        try {
            ServiceFinder.setIteratorProvider((ServiceFinder.ServiceIteratorProvider)iteratorProvider);
            RestLogging.restLogger.log(Level.FINEST, () -> String.valueOf(this) + ": Creating Jersey container for " + String.valueOf(HttpHandler.class) + " and " + String.valueOf(config));
            final GrizzlyHttpContainer httpHandler = (GrizzlyHttpContainer)ContainerFactory.createContainer(GrizzlyHttpContainer.class, (Application)config);
            ServiceLocator jerseyLocator = (ServiceLocator)httpHandler.getApplicationHandler().getInjectionManager().getInstance(ServiceLocator.class);
            ExtrasUtilities.enableTopicDistribution((ServiceLocator)jerseyLocator);
            JerseyContainer jerseyContainer = new JerseyContainer(){

                @Override
                public void service(Request request, Response response) throws Exception {
                    httpHandler.service(request, response);
                }
            };
            return jerseyContainer;
        }
        finally {
            iteratorProvider.disable();
        }
    }

    private Set<? extends Binder> getAdditionalBinders() {
        return Collections.singleton(new AbstractBinder(){

            @Override
            protected void configure() {
                this.bindFactory(RestAdapter.SubjectReferenceFactory.class).to(new TypeLiteral<Ref<Subject>>(){}).in(PerLookup.class);
                this.bindFactory(Hk2ReferencingFactory.referenceFactory()).to(new TypeLiteral<Ref<Subject>>(){}).in(RequestScoped.class);
            }
        });
    }
}

