/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.node.ws;

import com.sun.enterprise.deployment.node.DeploymentDescriptorNode;
import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.runtime.ws.ReliabilityConfig;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ReliabilityConfigNode
extends DeploymentDescriptorNode<ReliabilityConfig> {
    private final XMLElement tag = new XMLElement("reliability-config");
    private final ReliabilityConfig rmConfig = new ReliabilityConfig();

    @Override
    protected XMLElement getXMLRootTag() {
        return this.tag;
    }

    @Override
    public ReliabilityConfig getDescriptor() {
        return this.rmConfig;
    }

    @Override
    protected Map<String, String> getDispatchTable() {
        Map<String, String> table = super.getDispatchTable();
        table.put("inactivity-timeout", "setInactivityTimeout");
        table.put("base-retransmission-interval", "setBaseRetransmissionInterval");
        table.put("retransmission-exponential-backoff", "setRetransmissionExponentialBackoff");
        table.put("acknowledgement-interval", "setAcknowledgementInterval");
        table.put("sequence-expiration", "setSequenceExpiration");
        table.put("buffer-retry-count", "setBufferRetryCount");
        table.put("buffer-retry-delay", "setBufferRetryDelay");
        return table;
    }

    @Override
    public Node writeDescriptor(Node parent, ReliabilityConfig descriptor) {
        if (descriptor != null) {
            Document doc = ReliabilityConfigNode.getOwnerDocument(parent);
            Element reliablityConfig = doc.createElement("reliability-config");
            this.addElementIfNonNull(doc, reliablityConfig, "inactivity-timeout", descriptor.getInactivityTimeout());
            this.addElementIfNonNull(doc, reliablityConfig, "base-retransmission-interval", descriptor.getBaseRetransmissionInterval());
            this.addElementIfNonNull(doc, reliablityConfig, "retransmission-exponential-backoff", descriptor.getRetransmissionExponentialBackoff());
            this.addElementIfNonNull(doc, reliablityConfig, "acknowledgement-interval", descriptor.getAcknowledgementInterval());
            this.addElementIfNonNull(doc, reliablityConfig, "sequence-expiration", descriptor.getSequenceExpiration());
            this.addElementIfNonNull(doc, reliablityConfig, "buffer-retry-count", descriptor.getBufferRetryCount());
            this.addElementIfNonNull(doc, reliablityConfig, "buffer-retry-delay", descriptor.getBufferRetryDelay());
            parent.appendChild(reliablityConfig);
            return reliablityConfig;
        }
        return null;
    }

    private void addElementIfNonNull(Document doc, Node parentNode, String tagName, String value) {
        if (value != null) {
            Element element = doc.createElement(tagName);
            element.appendChild(doc.createTextNode(value));
            parentNode.appendChild(element);
        }
    }
}

