/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.multibroker.raptor;

import com.sun.messaging.jmq.io.GPacket;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.cluster.api.ClusterProtocolHelper;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.multibroker.Cluster;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.IOException;

public class ClusterReplicationGroupInfo
implements ClusterProtocolHelper {
    protected Logger logger = Globals.getLogger();
    private String groupName = null;
    private String nodeName = null;
    private String masterHostPort = null;
    private Cluster c = null;
    private GPacket pkt = null;

    private ClusterReplicationGroupInfo(String groupName, String nodeName, String masterHostPort, Cluster c) {
        this.groupName = groupName;
        this.nodeName = nodeName;
        this.masterHostPort = masterHostPort;
        this.c = c;
    }

    private ClusterReplicationGroupInfo(GPacket pkt, Cluster c) {
        this.pkt = pkt;
        this.c = c;
    }

    public static ClusterReplicationGroupInfo newInstance(String groupName, String nodeName, String masterHostPort, Cluster c) {
        return new ClusterReplicationGroupInfo(groupName, nodeName, masterHostPort, c);
    }

    public static ClusterReplicationGroupInfo newInstance(GPacket pkt, Cluster c) {
        return new ClusterReplicationGroupInfo(pkt, c);
    }

    public GPacket getGPacket() throws IOException {
        GPacket gp = GPacket.getInstance();
        gp.setType((short)55);
        gp.putProp("groupName", this.groupName);
        gp.putProp("nodeName", this.nodeName);
        gp.putProp("masterHostPort", this.masterHostPort);
        gp.putProp("clusterid", Globals.getClusterID());
        gp.putProp("TS", System.currentTimeMillis());
        this.c.marshalBrokerAddress(this.c.getSelfAddress(), gp);
        gp.setBit(1, false);
        return gp;
    }

    public String getGroupName() {
        assert (this.pkt != null);
        return (String)this.pkt.getProp("groupName");
    }

    public String getNodeName() {
        assert (this.pkt != null);
        return (String)this.pkt.getProp("nodeName");
    }

    public String getMasterHostPort() {
        assert (this.pkt != null);
        return (String)this.pkt.getProp("masterHostPort");
    }

    public String getClusterId() {
        assert (this.pkt != null);
        return (String)this.pkt.getProp("clusterid");
    }

    public Long getTimestamp() {
        assert (this.pkt != null);
        return (Long)this.pkt.getProp("TS");
    }

    public BrokerAddress getOwnerAddress() throws Exception {
        assert (this.pkt != null);
        return this.c.unmarshalBrokerAddress(this.pkt);
    }

    @Override
    public void sendReply(BrokerAddress recipient, int status, String reason, Object extraInfo) {
    }

    @Override
    public String toString() {
        if (this.pkt == null) {
            return "[" + this.groupName + "[" + this.nodeName + ", " + this.masterHostPort + "]";
        }
        return "[" + this.getGroupName() + "[" + this.getNodeName() + ", " + this.getMasterHostPort() + "]" + this.getTimestamp() + "]";
    }
}

