/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.comm;

import com.sun.messaging.jmq.jmsserver.audit.api.MQAuditService;
import com.sun.messaging.jmq.jmsserver.audit.api.MQAuditSession;
import com.sun.messaging.jmq.jmsserver.comm.CommBroker;
import com.sun.messaging.jmq.jmsserver.config.BrokerConfig;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.util.LockFile;
import com.sun.messaging.jmq.jmsserver.util.LoggerManager;
import com.sun.messaging.jmq.jmsservice.BrokerEvent;
import com.sun.messaging.jmq.util.MQResourceBundle;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Properties;
import org.glassfish.hk2.api.ServiceLocator;

public class CommGlobals {
    private static final String[] saveStrings = new String[]{"imq.cluster.ha", "imq.cluster.clusterid", "imq.brokerid", "imq.persist.store", "imq.persist.jdbc.*"};
    public static final String IMQ = "imq";
    protected static final Object lock = CommGlobals.class;
    private static volatile BrokerResources br = null;
    protected static volatile Logger logger = null;
    private static boolean clearProps = false;
    private static Properties saveProps = null;
    private static Object myaddrObject = null;
    private static volatile MQAuditSession audit = null;
    public static final String DEFAULT_INSTANCE = "imqbroker";
    private static String configName = "imqbroker";
    private static Properties parameters = null;
    private static volatile BrokerConfig config = null;
    private static CommBroker commBroker = null;
    private static ServiceLocator habitat = null;
    public static final String JMQ_HOME_PROPERTY = "imq.home";
    public static final String JMQ_VAR_HOME_PROPERTY = "imq.varhome";
    public static final String JMQ_INSTANCES_HOME_PROPERTY = "imq.instanceshome";
    public static final String JMQ_ETC_HOME_PROPERTY = "imq.etchome";
    public static final String JMQ_LIB_HOME_PROPERTY = "imq.libhome";
    public static final String JMQ_HOME_default = ".";
    public static final String JMQ_VAR_HOME_default = "var";
    public static final String JMQ_ETC_HOME_default_etc = "etc";
    public static final String JMQ_ETC_HOME_default_etcmq = "etc/mq";
    private static String JMQ_HOME;
    private static String JMQ_VAR_HOME;
    private static String JMQ_ETC_HOME;
    private static String JMQ_LIB_HOME;
    public static final String INSTANCES_HOME_DIRECTORY = "instances";
    private static String JMQ_INSTANCES_HOME;
    private static boolean pathinited;
    public static final String JMQ_BROKER_PROP_LOC;
    public static final String NUCLEUS_MANAGED_PROPERTY = "imq.nucleus.managed";
    public static final String JMSRA_MANAGED_PROPERTY = "imq.jmsra.managed";

    public static void cleanupComm() {
        br = null;
        logger = null;
        audit = null;
        MQAuditService.clear();
        config = null;
        parameters = null;
        clearProps = false;
        saveProps = null;
        pathinited = false;
        myaddrObject = null;
        commBroker = null;
        habitat = null;
    }

    protected CommGlobals() {
    }

    protected static Properties getParameters() {
        return parameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MQAuditSession getAuditSession() {
        if (audit == null) {
            Object object = lock;
            synchronized (object) {
                if (audit == null) {
                    MQAuditService.init();
                    try {
                        audit = MQAuditService.getAuditSession();
                        LockFile lf = LockFile.getCurrentLockFile();
                        if (lf != null) {
                            audit.setInstance(lf.getInstance(), lf.getHost(), lf.getPort());
                        }
                    }
                    catch (BrokerException ex) {
                        CommGlobals.getLogger().logStack(32, ex.toString(), (Throwable)ex);
                        CommGlobals.getCommBroker().exit(1, ex.toString(), BrokerEvent.Type.EXCEPTION);
                    }
                }
            }
        }
        return audit;
    }

    public static void init(Properties params, boolean clearprops, boolean saveprops) {
        CommGlobals.pathinit(null);
        clearProps = clearprops;
        if (params == null) {
            return;
        }
        if (saveprops) {
            saveProps = new Properties();
            for (int i = 0; i < saveStrings.length; ++i) {
                if (saveStrings[i].endsWith("*")) {
                    String match = saveStrings[i].substring(0, saveStrings[i].length() - 1);
                    Enumeration<?> e = params.propertyNames();
                    while (e.hasMoreElements()) {
                        String key = (String)e.nextElement();
                        if (!key.startsWith(match)) continue;
                        String val = params.getProperty(key);
                        saveProps.put(key, val);
                    }
                    continue;
                }
                String val = params.getProperty(saveStrings[i]);
                if (val == null) continue;
                saveProps.put(saveStrings[i], val);
            }
        }
        configName = params.getProperty("imq.instancename", DEFAULT_INSTANCE);
        params.setProperty(JMQ_VAR_HOME_PROPERTY, JMQ_VAR_HOME);
        params.setProperty(JMQ_LIB_HOME_PROPERTY, JMQ_LIB_HOME);
        params.setProperty(JMQ_ETC_HOME_PROPERTY, JMQ_ETC_HOME);
        params.setProperty(JMQ_INSTANCES_HOME_PROPERTY, JMQ_INSTANCES_HOME);
        params.setProperty(JMQ_HOME_PROPERTY, JMQ_HOME);
        params.setProperty("imq.instancename", configName);
        parameters = params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BrokerResources getBrokerResources() {
        if (br == null) {
            Object object = lock;
            synchronized (object) {
                if (br == null) {
                    br = BrokerResources.getResources(Locale.getDefault());
                }
            }
        }
        return br;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Logger getLogger() {
        if (logger == null) {
            Object object = lock;
            synchronized (object) {
                if (logger == null) {
                    logger = new Logger(JMQ_VAR_HOME);
                    logger.setResourceBundle((MQResourceBundle)CommGlobals.getBrokerResources());
                }
            }
        }
        return logger;
    }

    public static Object getMyAddressObject() {
        return myaddrObject;
    }

    public static void setMyAddressObject(Object o) {
        myaddrObject = o;
    }

    public static CommBroker getCommBroker() {
        return commBroker;
    }

    public static void setCommBroker(CommBroker b) {
        commBroker = b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BrokerConfig getConfig() {
        if (config == null) {
            Object object = lock;
            synchronized (object) {
                if (config == null) {
                    try {
                        config = new BrokerConfig(configName, parameters, clearProps, saveProps);
                    }
                    catch (BrokerException ex) {
                        CommGlobals.getLogger().logStack(32, "Internal Error: Unable to load broker, configuration properties are not available. Exiting", ex.getCause());
                        CommGlobals.getCommBroker().exit(-1, "Internal Error: Unable to load broker, configuration properties are not available. Exiting", BrokerEvent.Type.FATAL_ERROR);
                    }
                    if (parameters != null) {
                        Enumeration<?> en = parameters.propertyNames();
                        Properties sysprops = System.getProperties();
                        while (en.hasMoreElements()) {
                            String name = (String)en.nextElement();
                            if (name.startsWith("imq.")) continue;
                            sysprops.put(name, parameters.getProperty(name));
                        }
                    }
                    Logger l = CommGlobals.getLogger();
                    l.configure((Properties)config, IMQ, CommGlobals.getCommBroker() != null && CommGlobals.getCommBroker().isInProcessBroker(), CommGlobals.isJMSRAManagedSpecified(), (ServiceLocator)(CommGlobals.isNucleusManagedBroker() ? habitat : null));
                    new LoggerManager(logger, config);
                }
            }
        }
        return config;
    }

    public static void setHabitat(ServiceLocator h) {
        habitat = h;
    }

    public static ServiceLocator getHabitat() {
        return habitat;
    }

    public static boolean isNucleusManagedBroker() {
        return CommGlobals.getConfig().getBooleanProperty(NUCLEUS_MANAGED_PROPERTY, false);
    }

    public static boolean isJMSRAManagedSpecified() {
        if (parameters == null) {
            return false;
        }
        String val = parameters.getProperty(JMSRA_MANAGED_PROPERTY);
        return val != null && Boolean.parseBoolean(val.trim());
    }

    public static boolean isJMSRAManagedBroker() {
        return CommGlobals.getConfig().getBooleanProperty(JMSRA_MANAGED_PROPERTY, false);
    }

    public static void reInitializeConfig(String name) {
        config = null;
        if (name == null) {
            name = DEFAULT_INSTANCE;
        }
        configName = name;
    }

    public static String getConfigName() {
        return configName;
    }

    public static String getInstanceDir() {
        return JMQ_INSTANCES_HOME + File.separator + configName;
    }

    public static String getInstanceEtcDir() {
        return JMQ_INSTANCES_HOME + File.separator + configName + File.separator + JMQ_ETC_HOME_default_etc;
    }

    public static void pathinit(Properties props) {
        Object path;
        block16: {
            File f;
            if (pathinited) {
                return;
            }
            pathinited = true;
            if (props == null) {
                props = System.getProperties();
            }
            path = props.getProperty(JMQ_HOME_PROPERTY, JMQ_HOME_default);
            try {
                path = new File((String)path).getCanonicalPath();
            }
            catch (IOException ex) {
                logger.log(32, "B3139", path, (Throwable)ex);
            }
            JMQ_HOME = path;
            path = props.getProperty(JMQ_VAR_HOME_PROPERTY, JMQ_HOME + File.separator + JMQ_VAR_HOME_default);
            try {
                path = new File((String)path).getCanonicalPath();
            }
            catch (IOException ex) {
                logger.log(32, "B3140", path, (Throwable)ex);
            }
            JMQ_VAR_HOME = path;
            path = props.getProperty(JMQ_LIB_HOME_PROPERTY, JMQ_HOME + File.separator + "lib");
            try {
                path = new File((String)path).getCanonicalPath();
            }
            catch (IOException ex) {
                logger.log(32, "B3141", path, (Throwable)ex);
            }
            JMQ_LIB_HOME = path;
            path = props.getProperty(JMQ_ETC_HOME_PROPERTY);
            if (path != null) {
                try {
                    f = new File((String)path);
                    if (!f.exists()) {
                        CommGlobals.getLogger().log(32, "B3142", path);
                        break block16;
                    }
                    path = new File((String)path).getCanonicalPath();
                }
                catch (IOException ex) {
                    CommGlobals.getLogger().log(32, "B3142", path, (Throwable)ex);
                }
            } else {
                path = JMQ_HOME + File.separator + JMQ_ETC_HOME_default_etcmq;
                f = new File((String)path);
                if (!f.exists()) {
                    path = JMQ_HOME + File.separator + JMQ_ETC_HOME_default_etc;
                    f = new File((String)path);
                }
                try {
                    path = f.getCanonicalPath();
                }
                catch (IOException ex) {
                    logger.log(32, "B3142", path, (Throwable)ex);
                }
            }
        }
        JMQ_ETC_HOME = path;
        JMQ_INSTANCES_HOME = JMQ_VAR_HOME + File.separator + INSTANCES_HOME_DIRECTORY;
    }

    public static String getJMQ_HOME() {
        return JMQ_HOME;
    }

    public static String getJMQ_LIB_HOME() {
        return JMQ_LIB_HOME;
    }

    public static String getJMQ_ETC_HOME() {
        return JMQ_ETC_HOME;
    }

    public static String getJMQ_VAR_HOME() {
        return JMQ_VAR_HOME;
    }

    public static String getJMQ_INSTANCES_HOME() {
        return JMQ_INSTANCES_HOME;
    }

    static {
        pathinited = false;
        JMQ_BROKER_PROP_LOC = "props" + File.separator + "broker" + File.separator;
    }
}

