/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jdeparser;

import java.io.IOException;
import java.util.ArrayList;
import org.jboss.jdeparser.BasicJAnnotatable;
import org.jboss.jdeparser.BlockContent;
import org.jboss.jdeparser.ClassContent;
import org.jboss.jdeparser.FormatPreferences;
import org.jboss.jdeparser.JClassItem;
import org.jboss.jdeparser.JExpr;
import org.jboss.jdeparser.JMod;
import org.jboss.jdeparser.JType;
import org.jboss.jdeparser.JVarDeclaration;
import org.jboss.jdeparser.SourceFileWriter;
import org.jboss.jdeparser.SuccessorJVarDeclaration;
import org.jboss.jdeparser.Tokens$;

class FirstJVarDeclaration
extends BasicJAnnotatable
implements JVarDeclaration,
BlockContent,
ClassContent,
JClassItem {
    private final int mods;
    private final JType type;
    private final String name;
    private final JExpr value;
    private ArrayList<SuccessorJVarDeclaration> successors;

    FirstJVarDeclaration(int mods, JType type, String name, JExpr value) {
        this.mods = mods;
        this.type = type;
        this.name = name;
        this.value = value;
    }

    @Override
    public void write(SourceFileWriter writer) throws IOException {
        this.write(writer, null);
    }

    void write(SourceFileWriter writer, FormatPreferences.Space beforeSemicolon) throws IOException {
        this.writeNoSemi(writer);
        writer.write(beforeSemicolon);
        writer.write(Tokens$.PUNCT.SEMI);
    }

    void writeNoSemi(SourceFileWriter writer) throws IOException {
        this.writeComments(writer);
        super.writeAnnotations(writer, FormatPreferences.Space.AFTER_ANNOTATION);
        JMod.write(writer, this.mods);
        writer.write(this.type);
        writer.sp();
        String name = this.name;
        JExpr value = this.value;
        writer.writeEscapedWord(name);
        if (value != null) {
            writer.write(Tokens$.PUNCT.BINOP.ASSIGN.getSpacingRule());
            writer.write(Tokens$.PUNCT.BINOP.ASSIGN);
            writer.write(Tokens$.PUNCT.BINOP.ASSIGN.getSpacingRule());
            writer.write(value);
        }
        if (this.successors != null) {
            for (SuccessorJVarDeclaration successor : this.successors) {
                writer.write(FormatPreferences.Space.BEFORE_COMMA);
                writer.write(Tokens$.PUNCT.COMMA);
                writer.write(FormatPreferences.Space.AFTER_COMMA);
                writer.writeEscapedWord(successor.name());
                value = successor.getValue();
                if (value == null) continue;
                writer.write(Tokens$.PUNCT.BINOP.ASSIGN.getSpacingRule());
                writer.write(Tokens$.PUNCT.BINOP.ASSIGN);
                writer.write(Tokens$.PUNCT.BINOP.ASSIGN.getSpacingRule());
                writer.write(value);
            }
        }
    }

    @Override
    public JType type() {
        return this.type;
    }

    @Override
    public String name() {
        return this.name;
    }

    int mods() {
        return this.mods;
    }

    @Override
    public JVarDeclaration add(String name, JExpr init) {
        if (this.successors == null) {
            this.successors = new ArrayList();
        }
        SuccessorJVarDeclaration s = new SuccessorJVarDeclaration(this, name, init);
        this.successors.add(s);
        return s;
    }

    @Override
    public JVarDeclaration add(String name) {
        if (this.successors == null) {
            this.successors = new ArrayList();
        }
        SuccessorJVarDeclaration s = new SuccessorJVarDeclaration(this, name, null);
        this.successors.add(s);
        return s;
    }

    @Override
    public JClassItem.Kind getItemKind() {
        return JClassItem.Kind.FIELD;
    }

    @Override
    public int getModifiers() {
        return this.mods;
    }

    @Override
    public boolean hasAllModifiers(int mods) {
        return (this.mods & mods) == mods;
    }

    @Override
    public boolean hasAnyModifier(int mods) {
        return (this.mods & mods) != 0;
    }

    @Override
    public String getName() {
        return this.name;
    }
}

