/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsclient;

import com.sun.jms.spi.xa.JMSXATopicSession;
import com.sun.messaging.jmq.jmsclient.JMSXAWrappedLock;
import com.sun.messaging.jmq.jmsclient.JMSXAWrappedTopicConnectionImpl;
import com.sun.messaging.jmq.jmsclient.JMSXAWrappedTransactionListener;
import com.sun.messaging.jmq.jmsclient.JMSXAWrappedXAResourceImpl;
import com.sun.messaging.jmq.jmsclient.JMSXAWrappedXSessionImpl;
import com.sun.messaging.jmq.jmsclient.XAResourceUnsupportedImpl;
import jakarta.jms.IllegalStateException;
import jakarta.jms.JMSException;
import jakarta.jms.TopicConnection;
import jakarta.jms.TopicSession;
import jakarta.jms.XASession;
import jakarta.jms.XATopicConnection;
import jakarta.jms.XATopicSession;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class JMSXAWrappedTopicSessionImpl
extends JMSXAWrappedXSessionImpl
implements JMSXATopicSession,
JMSXAWrappedTransactionListener {
    private JMSXAWrappedTopicConnectionImpl wconn_ = null;

    public JMSXAWrappedTopicSessionImpl(TopicConnection tconn, boolean transacted, int ackMode, JMSXAWrappedTopicConnectionImpl wconn) throws JMSException {
        this.wconn_ = wconn;
        if (tconn instanceof XATopicConnection) {
            this.session_ = ((XATopicConnection)tconn).createXATopicSession();
            this.xaresource_ = new JMSXAWrappedXAResourceImpl(((XASession)this.session_).getXAResource(), false, wconn.getJMSXAWrappedConnectionFactory(), wconn.getUsername(), wconn.getPassword());
            this.delaySessionCloseForRAR_ = JMSXAWrappedXAResourceImpl.isSystemPropertySetFor("delaySessionCloseForExternalJMSXAResource", this.xaresource_.getDelegatedXAResource().getClass().getName());
            this.ignoreSessionCloseForRAR_ = JMSXAWrappedXAResourceImpl.isSystemPropertySetFor("ignoreSessionCloseForExternalJMSXAResource", this.xaresource_.getDelegatedXAResource().getClass().getName());
            if (this.delaySessionCloseForRAR_) {
                JMSXAWrappedTopicSessionImpl.log(System.Logger.Level.INFO, "Enable delay Session.close() for " + this.xaresource_.getDelegatedXAResource().getClass().getName());
                this.lock_ = new JMSXAWrappedLock();
                this.xaresource_.setTransactionListener(this);
            }
        } else {
            this.session_ = tconn.createTopicSession(transacted, ackMode);
            this.nonxaresource_ = new XAResourceUnsupportedImpl();
        }
    }

    @Override
    public void afterTransactionComplete(Xid foreignXid, boolean completed) {
        try {
            if (completed) {
                if (debug && this.transactions_.get(foreignXid) == null) {
                    JMSXAWrappedTopicSessionImpl.log(System.Logger.Level.WARNING, "afterTransactionComplete: transaction Xid=" + String.valueOf(foreignXid) + " not found");
                }
                this.transactions_.remove(foreignXid);
            }
            if (this.transactions_.isEmpty() && this.markClosed_) {
                JMSXAWrappedTopicSessionImpl.dlog("All transaction completed, hard close session " + String.valueOf(this.session_) + " " + this.session_.getClass().getName());
                this.closed_ = true;
            }
        }
        finally {
            this.lock_.releaseLock();
        }
        if (this.closed_) {
            try {
                this.hardClose();
            }
            catch (JMSException e) {
                JMSXAWrappedTopicSessionImpl.logWarning((Exception)((Object)e));
            }
        }
    }

    @Override
    public void close() throws JMSException {
        if (this.delaySessionCloseForRAR_) {
            if (this.session_.getMessageListener() != null) {
                JMSXAWrappedTopicSessionImpl.log(System.Logger.Level.INFO, "Session MessageListener set. No delay session close for session " + String.valueOf(this.session_) + " " + this.session_.getClass().getName());
            } else {
                this.lock_.acquireLock();
                try {
                    if (this.transactions_.isEmpty() || this.xaresource_ == null) {
                        this.closed_ = true;
                    } else {
                        this.markClosed_ = true;
                    }
                }
                finally {
                    this.lock_.releaseLock();
                }
                if (this.closed_) {
                    this.hardClose();
                }
                return;
            }
        }
        if (this.ignoreSessionCloseForRAR_) {
            this.hardClose(false);
            return;
        }
        this.hardClose();
    }

    @Override
    public XAResource getXAResource() {
        if (this.session_ instanceof XASession) {
            return this.xaresource_;
        }
        return this.nonxaresource_;
    }

    @Override
    public TopicSession getTopicSession() throws JMSException {
        if (this.closed_) {
            throw new IllegalStateException("JMSXWrapped Session has been closed");
        }
        if (this.markClosed_) {
            throw new IllegalStateException("JMSXAWrapped Session is closed");
        }
        if (this.session_ instanceof XASession) {
            return ((XATopicSession)this.session_).getTopicSession();
        }
        return (TopicSession)this.session_;
    }

    @Override
    void removeSelfFromConnection() {
        this.wconn_.removeSession(this);
    }
}

