/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.server;

import com.sun.enterprise.module.bootstrap.StartupContext;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.enterprise.v3.server.APIClassLoaderServiceImpl;
import jakarta.inject.Inject;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.common.util.GlassfishUrlClassLoader;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.kernel.KernelLoggerInfo;
import org.jvnet.hk2.annotations.Service;

@Service
public class CommonClassLoaderServiceImpl
implements PostConstruct {
    private GlassfishUrlClassLoader commonClassLoader;
    @Inject
    APIClassLoaderServiceImpl acls;
    @Inject
    ServerEnvironment env;
    static final Logger logger = KernelLoggerInfo.getLogger();
    private ClassLoader APIClassLoader;
    private String commonClassPath = "";
    private static final String SERVER_EXCLUDED_ATTR_NAME = "GlassFish-ServerExcluded";

    public void postConstruct() {
        this.APIClassLoader = this.acls.getAPIClassLoader();
        assert (this.APIClassLoader != null);
        this.createCommonClassLoader();
    }

    private void createCommonClassLoader() {
        File domainLib;
        ArrayList<File> cpElements = new ArrayList<File>();
        File domainDir = this.env.getInstanceRoot();
        String installRoot = System.getProperty("com.sun.aas.installRoot");
        if (installRoot != null) {
            File installDir = new File(installRoot);
            File installLibPath = new File(installDir, "lib");
            if (installLibPath.isDirectory()) {
                Collections.addAll(cpElements, installLibPath.listFiles(new CompiletimeJarFileFilter()));
            }
        } else {
            logger.logp(Level.WARNING, "CommonClassLoaderServiceImpl", "createCommonClassLoader", "NCLS-CORE-00044", "com.sun.aas.installRoot");
        }
        File domainClassesDir = new File(domainDir, "lib/classes/");
        if (domainClassesDir.exists()) {
            cpElements.add(domainClassesDir);
        }
        if ((domainLib = new File(domainDir, "lib/")).isDirectory()) {
            Collections.addAll(cpElements, domainLib.listFiles(new JarFileFilter()));
        }
        cpElements.addAll(this.findDerbyClient());
        ArrayList<URL> urls = new ArrayList<URL>();
        for (File f : cpElements) {
            try {
                urls.add(f.toURI().toURL());
            }
            catch (MalformedURLException e) {
                logger.log(Level.WARNING, "NCLS-CORE-00045", new Object[]{f, e});
            }
        }
        this.commonClassPath = CommonClassLoaderServiceImpl.urlsToClassPath(urls.stream());
        if (urls.isEmpty()) {
            logger.logp(Level.FINE, "CommonClassLoaderManager", "Skipping creation of CommonClassLoader as there are no libraries available", "urls = {0}", urls);
        } else {
            this.commonClassLoader = new GlassfishUrlClassLoader((URL[])urls.toArray(URL[]::new), this.APIClassLoader);
        }
    }

    public ClassLoader getCommonClassLoader() {
        return this.commonClassLoader != null ? this.commonClassLoader : this.APIClassLoader;
    }

    public void addToClassPath(URL url) {
        CommonClassLoaderServiceImpl.validateUrl(url);
        if (this.commonClassLoader == null) {
            this.commonClassLoader = new GlassfishUrlClassLoader(new URL[]{url}, this.APIClassLoader);
        } else {
            this.commonClassLoader.addURL(url);
        }
        this.commonClassPath = CommonClassLoaderServiceImpl.urlsToClassPath(Arrays.stream(this.commonClassLoader.getURLs()));
    }

    public String getCommonClassPath() {
        return this.commonClassPath;
    }

    private static URL validateUrl(URL url) {
        if (url == null) {
            throw new IllegalArgumentException("URL cannot be null");
        }
        if (!url.getProtocol().equalsIgnoreCase("file")) {
            throw new IllegalArgumentException("URL must be a file URL");
        }
        if (url.getPath().isEmpty()) {
            throw new IllegalArgumentException("URL path cannot be empty");
        }
        return url;
    }

    private static String urlsToClassPath(Stream<URL> urls) {
        return urls.map(FileUtils::toFile).map(File::getAbsolutePath).collect(Collectors.joining(File.pathSeparator));
    }

    private List<File> findDerbyClient() {
        String DERBY_HOME_PROP = "AS_DERBY_INSTALL";
        StartupContext startupContext = this.env.getStartupContext();
        Properties arguments = null;
        if (startupContext != null) {
            arguments = startupContext.getArguments();
        }
        String derbyHome = null;
        if (arguments != null) {
            derbyHome = arguments.getProperty("AS_DERBY_INSTALL", System.getProperty("AS_DERBY_INSTALL"));
        }
        File derbyLib = null;
        if (derbyHome != null) {
            derbyLib = new File(derbyHome, "lib");
        }
        if (derbyLib == null || !derbyLib.exists()) {
            logger.info("NCLS-CORE-00046");
            return Collections.emptyList();
        }
        return Arrays.asList(derbyLib.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".jar") && !name.startsWith("derbyLocale_");
            }
        }));
    }

    private static class CompiletimeJarFileFilter
    extends JarFileFilter {
        private CompiletimeJarFileFilter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean accept(File dir, String name) {
            if (super.accept(dir, name)) {
                File file = new File(dir, name);
                JarFile jar = null;
                try {
                    String exclude;
                    jar = new JarFile(file);
                    Manifest manifest = jar.getManifest();
                    if (manifest != null && (exclude = manifest.getMainAttributes().getValue(CommonClassLoaderServiceImpl.SERVER_EXCLUDED_ATTR_NAME)) != null && exclude.equalsIgnoreCase("true")) {
                        boolean bl = false;
                        return bl;
                    }
                }
                catch (IOException e) {
                    logger.log(Level.WARNING, "NCLS-CORE-00047", new Object[]{file.getAbsolutePath(), e});
                }
                finally {
                    try {
                        if (jar != null) {
                            jar.close();
                        }
                    }
                    catch (IOException iOException) {}
                }
                return true;
            }
            return false;
        }
    }

    private static class JarFileFilter
    implements FilenameFilter {
        private final String JAR_EXT = ".jar";

        private JarFileFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(".jar");
        }
    }
}

