/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.exousia.modules.locked;

import jakarta.security.jacc.PolicyConfiguration;
import jakarta.security.jacc.PolicyContext;
import jakarta.security.jacc.PolicyContextException;
import jakarta.security.jacc.PolicyContextHandler;
import java.lang.reflect.Constructor;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Principal;
import java.security.ProtectionDomain;
import java.security.SecurityPermission;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Logger;
import org.glassfish.exousia.modules.locked.AuthorizationRoleMapper;
import org.glassfish.exousia.modules.locked.Role;
import org.glassfish.exousia.modules.locked.SharedState;

public class SimplePolicyConfiguration
implements PolicyConfiguration {
    private static final System.Logger LOG;
    public static final int OPEN_STATE = 0;
    public static final int INSERVICE_STATE = 2;
    public static final int DELETED_STATE = 3;
    private static final Permission setPolicyPermission;
    private final String contextId;
    private int state = 0;
    private PermissionCollection excludedPermissions;
    private PermissionCollection uncheckedPermissions;
    private List<Role> roleTable;
    private final ReentrantReadWriteLock policyContextLock = new ReentrantReadWriteLock(true);
    private final Lock readLock = this.policyContextLock.readLock();
    private final Lock writeLock = this.policyContextLock.writeLock();

    protected SimplePolicyConfiguration(String contextID) {
        this.contextId = contextID;
    }

    public String getContextID() throws PolicyContextException {
        return this.contextId;
    }

    public void addToRole(String roleName, PermissionCollection permissions) throws PolicyContextException {
        SimplePolicyConfiguration.checkSetPolicyPermission();
        this.writeLock.lock();
        try {
            this.assertStateIsOpen();
            if (roleName != null && permissions != null) {
                this.getRole(roleName).addPermissions(permissions);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void addToRole(String roleName, Permission permission) throws PolicyContextException {
        SimplePolicyConfiguration.checkSetPolicyPermission();
        this.writeLock.lock();
        try {
            this.assertStateIsOpen();
            if (roleName != null && permission != null) {
                this.getRole(roleName).addPermission(permission);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void addToUncheckedPolicy(PermissionCollection permissions) throws PolicyContextException {
        SimplePolicyConfiguration.checkSetPolicyPermission();
        this.writeLock.lock();
        try {
            this.assertStateIsOpen();
            if (permissions != null) {
                Enumeration<Permission> e = permissions.elements();
                while (e.hasMoreElements()) {
                    this.getUncheckedPermissions().add(e.nextElement());
                }
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void addToUncheckedPolicy(Permission permission) throws PolicyContextException {
        SimplePolicyConfiguration.checkSetPolicyPermission();
        this.writeLock.lock();
        try {
            this.assertStateIsOpen();
            if (permission != null) {
                this.getUncheckedPermissions().add(permission);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void addToExcludedPolicy(PermissionCollection permissions) throws PolicyContextException {
        SimplePolicyConfiguration.checkSetPolicyPermission();
        this.writeLock.lock();
        try {
            this.assertStateIsOpen();
            if (permissions != null) {
                Enumeration<Permission> e = permissions.elements();
                while (e.hasMoreElements()) {
                    this.getExcludedPermissions().add(e.nextElement());
                }
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void addToExcludedPolicy(Permission permission) throws PolicyContextException {
        SimplePolicyConfiguration.checkSetPolicyPermission();
        this.writeLock.lock();
        try {
            this.assertStateIsOpen();
            if (permission != null) {
                this.getExcludedPermissions().add(permission);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void removeRole(String roleName) throws PolicyContextException {
        SimplePolicyConfiguration.checkSetPolicyPermission();
        this.writeLock.lock();
        try {
            this.assertStateIsOpen();
            if (roleName != null && this.roleTable != null) {
                if (!this.roleTable.remove(new Role(roleName))) {
                    if (roleName.equals("*")) {
                        this.roleTable.clear();
                        this.roleTable = null;
                    }
                } else if (this.roleTable.isEmpty()) {
                    this.roleTable = null;
                }
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void removeUncheckedPolicy() throws PolicyContextException {
        SimplePolicyConfiguration.checkSetPolicyPermission();
        this.writeLock.lock();
        try {
            this.assertStateIsOpen();
            this.uncheckedPermissions = null;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void removeExcludedPolicy() throws PolicyContextException {
        SimplePolicyConfiguration.checkSetPolicyPermission();
        this.writeLock.lock();
        try {
            this.assertStateIsOpen();
            this.excludedPermissions = null;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void linkConfiguration(PolicyConfiguration link) throws PolicyContextException {
        SimplePolicyConfiguration.checkSetPolicyPermission();
        this.readLock.lock();
        try {
            this.assertStateIsOpen();
        }
        finally {
            this.readLock.unlock();
        }
        SharedState.link(this.contextId, link.getContextID());
    }

    public void delete() throws PolicyContextException {
        SimplePolicyConfiguration.checkSetPolicyPermission();
        SharedState.removeLinks(this.contextId);
        this.writeLock.lock();
        try {
            this.removePolicy();
        }
        finally {
            try {
                this.setState(3);
            }
            finally {
                this.writeLock.unlock();
            }
        }
    }

    public void commit() throws PolicyContextException {
        SimplePolicyConfiguration.checkSetPolicyPermission();
        boolean initRoles = false;
        this.writeLock.lock();
        try {
            if (this.stateIs(3)) {
                String msg = "pc.invalid_op_for_state_delete";
                throw new UnsupportedOperationException(msg);
            }
            if (this.stateIs(0)) {
                if (this.roleTable != null) {
                    initRoles = true;
                }
                this.setState(2);
            }
        }
        finally {
            this.writeLock.unlock();
        }
        if (initRoles) {
            this.commitRoleMapping();
        }
    }

    public boolean inService() throws PolicyContextException {
        this.readLock.lock();
        try {
            boolean bl = this.stateIs(2);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Map<String, PermissionCollection> getPerRolePermissions() {
        return null;
    }

    public PermissionCollection getUncheckedPermissions() {
        if (this.uncheckedPermissions == null) {
            this.uncheckedPermissions = new Permissions();
        }
        return this.uncheckedPermissions;
    }

    public PermissionCollection getExcludedPermissions() {
        if (this.excludedPermissions == null) {
            this.excludedPermissions = new Permissions();
        }
        return this.excludedPermissions;
    }

    protected static SimplePolicyConfiguration getPolicyConfig(String pcid, boolean remove) throws PolicyContextException {
        SimplePolicyConfiguration simplePolicyConfiguration = SharedState.getConfig(pcid, remove);
        simplePolicyConfiguration.writeLock.lock();
        try {
            if (remove) {
                simplePolicyConfiguration.removePolicy();
            }
            simplePolicyConfiguration.setState(0);
        }
        finally {
            simplePolicyConfiguration.writeLock.unlock();
        }
        return simplePolicyConfiguration;
    }

    protected static boolean inService(String pcid) throws PolicyContextException {
        SimplePolicyConfiguration simplePolicyConfiguration = SimplePolicyConfiguration.getPolicyConfig(pcid);
        if (simplePolicyConfiguration == null) {
            return false;
        }
        return simplePolicyConfiguration.inService();
    }

    protected static SimplePolicyConfiguration getPolicyConfig(String pcid) {
        return SharedState.lookupConfig(pcid);
    }

    protected static void checkSetPolicyPermission() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(setPolicyPermission);
        }
    }

    private void setState(int stateValue) {
        this.state = stateValue;
    }

    private boolean stateIs(int stateValue) {
        return this.state == stateValue;
    }

    private void assertStateIsOpen() throws UnsupportedOperationException {
        if (!this.stateIs(0)) {
            throw new UnsupportedOperationException("Operation invoked on closed or deleted PolicyConfiguration.");
        }
    }

    private void assertStateIsInService() throws UnsupportedOperationException {
        if (!this.stateIs(2)) {
            throw new UnsupportedOperationException("Operation invoked on open or deleted PolicyConfiguration.");
        }
    }

    private Role getRole(String roleName) {
        int index = -1;
        Role role = new Role(roleName);
        if (this.roleTable == null) {
            this.roleTable = new ArrayList<Role>();
        } else {
            index = this.roleTable.indexOf(role);
        }
        if (index < 0) {
            this.roleTable.add(role);
        } else {
            role = this.roleTable.get(index);
        }
        return role;
    }

    private void removePolicy() {
        this.excludedPermissions = null;
        this.uncheckedPermissions = null;
        this.roleTable = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commitRoleMapping() throws PolicyContextException {
        AuthorizationRoleMapper roleMapper = null;
        try {
            roleMapper = (AuthorizationRoleMapper)PolicyContext.getContext((String)"simple.jacc.provider.RoleMapper");
            if (roleMapper == null) {
                throw new PolicyContextException("RoleMapper lookup null");
            }
        }
        catch (Throwable t) {
            LOG.log(System.Logger.Level.ERROR, "RoleMapper lookup failed", t);
            if (t instanceof PolicyContextException) {
                throw (PolicyContextException)t;
            }
            throw new PolicyContextException(t);
        }
        this.writeLock.lock();
        try {
            if (this.roleTable != null) {
                for (Role role : this.roleTable) {
                    role.setPrincipals(roleMapper.getPrincipalsInRole(this.contextId, role.getName()));
                }
                Role anyAuthRole = new Role("**");
                int index = this.roleTable.indexOf(anyAuthRole);
                if (index != -1) {
                    anyAuthRole = this.roleTable.get(index);
                    anyAuthRole.determineAnyAuthenticatedUserRole();
                }
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public static PermissionCollection getPermissions(PermissionCollection basePerms, CodeSource codesource) throws PolicyContextException {
        SimplePolicyConfiguration policyConfiguration = SharedState.getActiveConfig();
        return policyConfiguration == null ? basePerms : policyConfiguration.getPermissions(basePerms, null, new Principal[0]);
    }

    public static PermissionCollection getPermissions(PermissionCollection basePerms, ProtectionDomain domain) throws PolicyContextException {
        SimplePolicyConfiguration policyConfiguration = SharedState.getActiveConfig();
        return policyConfiguration == null ? basePerms : policyConfiguration.getPermissions(basePerms, domain.getPermissions(), domain.getPrincipals());
    }

    public static int implies(ProtectionDomain domain, Permission permission) throws PolicyContextException {
        SimplePolicyConfiguration policyConfiguration = SharedState.getActiveConfig();
        return policyConfiguration == null ? 0 : policyConfiguration.doImplies(domain, permission);
    }

    private boolean permissionIsExcluded(Permission testedPermission) {
        boolean isExcluded = false;
        if (this.hasExcludedPermissions()) {
            if (!this.getExcludedPermissions().implies(testedPermission)) {
                Enumeration<Permission> e = this.excludedPermissions.elements();
                while (e.hasMoreElements()) {
                    Permission excludedPerm = e.nextElement();
                    if (!testedPermission.implies(excludedPerm)) continue;
                    isExcluded = true;
                    break;
                }
            } else {
                isExcluded = true;
            }
        }
        return isExcluded;
    }

    private int doImplies(ProtectionDomain protectionDomain, Permission permission) throws PolicyContextException {
        this.readLock.lock();
        try {
            LOG.log(System.Logger.Level.DEBUG, "doImplies, roleTable: {0}, permission: {1}, protectionDomain: {2}", this.roleTable, permission, protectionDomain);
            this.assertStateIsInService();
            if (this.permissionIsExcluded(permission)) {
                int n = -1;
                return n;
            }
            if (this.getUncheckedPermissions().implies(permission)) {
                int n = 1;
                return n;
            }
            if (this.roleTable != null) {
                Principal[] principals = protectionDomain.getPrincipals();
                if (principals.length == 0) {
                    int n = 0;
                    return n;
                }
                for (Role role : this.roleTable) {
                    if (!role.arePrincipalsInRole(principals) || !role.implies(permission)) continue;
                    int n = 1;
                    return n;
                }
            }
            int principals = 0;
            return principals;
        }
        catch (UnsupportedOperationException uso) {
            throw new PolicyContextException((Throwable)uso);
        }
        finally {
            this.readLock.unlock();
        }
    }

    private boolean hasExcludedPermissions() {
        return this.excludedPermissions != null && this.excludedPermissions.elements().hasMoreElements();
    }

    private PermissionCollection getPermissions(PermissionCollection basePerms, PermissionCollection domainPerms, Principal[] principals) throws PolicyContextException, UnsupportedOperationException {
        this.readLock.lock();
        try {
            Object object;
            Permission permission;
            Enumeration<Permission> e;
            this.assertStateIsInService();
            Permissions permissions = null;
            boolean hasExcludes = this.hasExcludedPermissions();
            if (basePerms != null) {
                e = basePerms.elements();
                while (e.hasMoreElements()) {
                    permission = e.nextElement();
                    if (hasExcludes && this.permissionIsExcluded(permission)) continue;
                    if (permissions == null) {
                        permissions = new Permissions();
                    }
                    permissions.add(permission);
                }
            }
            if (domainPerms != null) {
                e = domainPerms.elements();
                while (e.hasMoreElements()) {
                    permission = e.nextElement();
                    if (hasExcludes && this.permissionIsExcluded(permission)) continue;
                    if (permissions == null) {
                        permissions = new Permissions();
                    }
                    permissions.add(permission);
                }
            }
            e = this.getUncheckedPermissions().elements();
            while (e.hasMoreElements()) {
                permission = e.nextElement();
                if (hasExcludes && this.permissionIsExcluded(permission)) continue;
                if (permissions == null) {
                    permissions = new Permissions();
                }
                permissions.add(permission);
            }
            if (principals.length == 0 || this.roleTable == null) {
                object = permissions;
                return object;
            }
            for (Role role : this.roleTable) {
                if (!role.arePrincipalsInRole(principals)) continue;
                Permissions permissionCollection = role.getPermissions();
                Enumeration<Permission> e2 = ((PermissionCollection)permissionCollection).elements();
                while (e2.hasMoreElements()) {
                    Permission permission2 = e2.nextElement();
                    if (hasExcludes && this.permissionIsExcluded(permission2)) continue;
                    if (permissions == null) {
                        permissions = new Permissions();
                    }
                    permissions.add(permission2);
                }
            }
            object = permissions;
            return object;
        }
        catch (UnsupportedOperationException uso) {
            throw new PolicyContextException((Throwable)uso);
        }
        finally {
            this.readLock.unlock();
        }
    }

    static void refresh() throws PolicyContextException {
    }

    static {
        block5: {
            LOG = System.getLogger(SimplePolicyConfiguration.class.getName());
            setPolicyPermission = new SecurityPermission("setPolicy");
            try {
                Object className = System.getProperty("simple.jacc.provider.JACCRoleMapper.class");
                if (className == null && PolicyContext.getHandlerKeys().contains("simple.jacc.provider.RoleMapper")) break block5;
                if (className == null) {
                    String packageName = SimplePolicyConfiguration.class.getPackage().getName();
                    className = packageName + ".GlassfishRoleMapper";
                }
                Constructor<?> constructorNoArg = null;
                Constructor<?> constructorJUL = null;
                try {
                    constructorNoArg = Thread.currentThread().getContextClassLoader().loadClass((String)className).getConstructor(new Class[0]);
                }
                catch (NoSuchMethodException e) {
                    constructorJUL = Thread.currentThread().getContextClassLoader().loadClass((String)className).getConstructor(Logger.class);
                }
                ExousiaPolicyContextHandler handler = new ExousiaPolicyContextHandler(constructorNoArg, constructorJUL);
                PolicyContext.registerHandler((String)"simple.jacc.provider.RoleMapper", (PolicyContextHandler)handler, (boolean)false);
            }
            catch (Throwable t) {
                throw new IllegalStateException("RoleMapper registration failed!", t);
            }
        }
    }

    private static class ExousiaPolicyContextHandler
    implements PolicyContextHandler {
        private final Constructor<?> constructorNoArg;
        private final Constructor<?> constructorJUL;

        private ExousiaPolicyContextHandler(Constructor<?> constructorNoArg, Constructor<?> constructorJUL) {
            this.constructorNoArg = constructorNoArg;
            this.constructorJUL = constructorJUL;
        }

        public Object getContext(String key, Object data) throws PolicyContextException {
            if (key.equals("simple.jacc.provider.RoleMapper")) {
                try {
                    if (this.constructorNoArg != null) {
                        return this.constructorNoArg.newInstance(new Object[0]);
                    }
                    return this.constructorJUL.newInstance(Logger.getLogger("jakarta.authorization"));
                }
                catch (Throwable t) {
                    throw new PolicyContextException(t);
                }
            }
            return null;
        }

        public String[] getKeys() throws PolicyContextException {
            return new String[]{"simple.jacc.provider.RoleMapper"};
        }

        public boolean supports(String key) throws PolicyContextException {
            return key.equals("simple.jacc.provider.RoleMapper");
        }
    }
}

