/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.management.mbeans;

import com.sun.messaging.jmq.jmsserver.core.Producer;
import com.sun.messaging.jmq.jmsserver.management.mbeans.MQMBeanReadWrite;
import java.util.Iterator;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;

public class ProducerManagerConfig
extends MQMBeanReadWrite {
    private static MBeanAttributeInfo[] attrs;
    private static MBeanOperationInfo[] ops;

    public Integer getNumProducers() {
        return Producer.getNumProducers();
    }

    public String[] getProducerIDs() throws MBeanException {
        int numProducers = this.getNumProducers();
        if (numProducers <= 0) {
            return null;
        }
        String[] ids = new String[numProducers];
        Iterator producers = Producer.getAllProducers();
        int i = 0;
        while (producers.hasNext()) {
            Producer oneProd = (Producer)producers.next();
            long prodID = oneProd.getProducerUID().longValue();
            try {
                String id;
                ids[i] = id = Long.toString(prodID);
            }
            catch (Exception ex) {
                this.handleOperationException("getProducerIDs", ex);
            }
            ++i;
        }
        return ids;
    }

    @Override
    public String getMBeanName() {
        return "ProducerManagerConfig";
    }

    @Override
    public String getMBeanDescription() {
        return mbr.getString("MB1141");
    }

    @Override
    public MBeanAttributeInfo[] getMBeanAttributeInfo() {
        return attrs;
    }

    @Override
    public MBeanOperationInfo[] getMBeanOperationInfo() {
        return ops;
    }

    @Override
    public MBeanNotificationInfo[] getMBeanNotificationInfo() {
        return null;
    }

    static {
        MBeanAttributeInfo[] mBeanAttributeInfoArray = new MBeanAttributeInfo[1];
        mBeanAttributeInfoArray[0] = new MBeanAttributeInfo("NumProducers", Integer.class.getName(), mbr.getString("MB1142"), true, false, false);
        attrs = mBeanAttributeInfoArray;
        MBeanOperationInfo[] mBeanOperationInfoArray = new MBeanOperationInfo[1];
        mBeanOperationInfoArray[0] = new MBeanOperationInfo("getProducerIDs", mbr.getString("MB1143"), null, String[].class.getName(), 0);
        ops = mBeanOperationInfoArray;
    }
}

