/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.management.agent;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.config.BrokerConfig;
import com.sun.messaging.jmq.jmsserver.management.agent.Agent;
import com.sun.messaging.jmq.jmsserver.management.agent.MQJMXAuthenticator;
import com.sun.messaging.jmq.jmsserver.management.agent.MQRMIServerSocketFactory;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.management.MQRMIClientSocketFactory;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.HashMap;
import javax.management.MBeanServer;
import javax.management.NotificationListener;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import javax.rmi.ssl.SslRMIClientSocketFactory;

public class ConnectorServerInfo {
    private static String CONNECTOR_PROPBASE = "imq.jmx.connector.";
    private static String PROTOCOL_SUFFIX = ".protocol";
    private static String PORT_SUFFIX = ".port";
    private static String URLPATH_SUFFIX = ".urlpath";
    private static String URL_SUFFIX = ".url";
    private static String SSL_SUFFIX = ".useSSL";
    private static String BROKER_HOST_TRUSTED_SUFFIX = ".brokerHostTrusted";
    private static String BACKLOG_SUFFIX = ".backlog";
    Agent agent;
    JMXConnectorServer connectorServer = null;
    JMXServiceURL configuredURL = null;
    String name = null;
    boolean configuredActive = false;
    boolean stopped = false;
    NotificationListener listener;
    private BrokerResources rb = Globals.getBrokerResources();

    public ConnectorServerInfo(Agent agent, String name, boolean configuredActive, NotificationListener listener) throws BrokerException {
        this.name = name;
        this.configuredActive = configuredActive;
        this.listener = listener;
        this.agent = agent;
        this.initURL();
    }

    public JMXServiceURL getConfiguredJMXServiceURL() {
        return this.configuredURL;
    }

    public JMXServiceURL getJMXServiceURL() {
        if (this.isActive()) {
            return this.connectorServer.getAddress();
        }
        return this.configuredURL;
    }

    public String getName() {
        return this.name;
    }

    public boolean isActive() {
        if (!this.configuredActive) {
            return false;
        }
        if (this.connectorServer == null) {
            return false;
        }
        return this.connectorServer.isActive();
    }

    public void start() throws IOException, BrokerException {
        if (!this.configuredActive) {
            throw new BrokerException(this.rb.getString("B2160", this.name));
        }
        this.initConnectorServer();
        this.connectorServer.start();
    }

    public void stop() throws IOException {
        if (!this.isActive()) {
            return;
        }
        this.connectorServer.stop();
        this.stopped = true;
        this.connectorServer = null;
        this.configuredURL = null;
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public int getPort() {
        return this.getJMXServiceURL().getPort();
    }

    public String getProtocol() {
        return this.getJMXServiceURL().getProtocol();
    }

    public JMXConnectorServer getConnectorServer() {
        return this.connectorServer;
    }

    private void initURL() throws BrokerException {
        JMXServiceURL url;
        String protocol = null;
        Object urlpath = null;
        String jmxurl = null;
        int port = 0;
        BrokerConfig config = Globals.getConfig();
        String jmxHostname = Globals.getJMXHostname();
        if (this.configuredURL != null) {
            return;
        }
        jmxurl = config.getProperty(CONNECTOR_PROPBASE + this.name + URL_SUFFIX);
        if (jmxurl == null) {
            protocol = config.getProperty(CONNECTOR_PROPBASE + this.name + PROTOCOL_SUFFIX, "rmi");
            port = config.getIntProperty(CONNECTOR_PROPBASE + this.name + PORT_SUFFIX, 0);
            urlpath = config.getProperty(CONNECTOR_PROPBASE + this.name + URLPATH_SUFFIX);
            if (urlpath == null && (this.agent.startRmiRegistry() || this.agent.useRmiRegistry())) {
                urlpath = this.agent.getDefaultJMXUrlPathBase() + this.name;
            }
        }
        try {
            url = jmxurl != null ? new JMXServiceURL(jmxurl) : (jmxHostname != null && !jmxHostname.equals("*") ? new JMXServiceURL(protocol, jmxHostname, port, (String)urlpath) : new JMXServiceURL(protocol, null, port, (String)urlpath));
        }
        catch (MalformedURLException mfe) {
            throw new BrokerException(this.rb.getString("B2161", this.name), mfe);
        }
        this.configuredURL = url;
    }

    private void initConnectorServer() throws BrokerException {
        JMXConnectorServer cs;
        BrokerConfig config = Globals.getConfig();
        MBeanServer mbs = this.agent.getMBeanServer();
        HashMap<String, Object> env = new HashMap<String, Object>();
        String jmxHostname = Globals.getJMXHostname();
        if (this.connectorServer != null) {
            return;
        }
        if (mbs == null) {
            throw new BrokerException(this.rb.getString("B4258", this.name));
        }
        boolean useSSL = config.getBooleanProperty(CONNECTOR_PROPBASE + this.name + SSL_SUFFIX, false);
        boolean brokerHostTrusted = config.getBooleanProperty(CONNECTOR_PROPBASE + this.name + BROKER_HOST_TRUSTED_SUFFIX, false);
        int backlog = config.getIntProperty(CONNECTOR_PROPBASE + this.name + BACKLOG_SUFFIX, 0);
        try {
            if (this.configuredURL.getProtocol().equals("rmi")) {
                MQRMIClientSocketFactory csf;
                boolean useAuth = true;
                if (useAuth) {
                    env.put("jmx.remote.authenticator", new MQJMXAuthenticator(this));
                }
                if (useSSL || jmxHostname != null && !jmxHostname.equals("*")) {
                    MQRMIServerSocketFactory ssf = new MQRMIServerSocketFactory(jmxHostname, backlog, useSSL);
                    env.put("jmx.remote.rmi.server.socket.factory", ssf);
                }
                if (jmxHostname != null && !jmxHostname.equals("*")) {
                    csf = new MQRMIClientSocketFactory(jmxHostname, brokerHostTrusted, useSSL);
                    env.put("jmx.remote.rmi.client.socket.factory", csf);
                    if ((Globals.isJMSRAManagedBroker() || Globals.isNucleusManagedBroker()) && this.agent.useRmiRegistry()) {
                        env.put("com.sun.jndi.rmi.factory.socket", csf);
                    }
                } else if (useSSL) {
                    if (brokerHostTrusted) {
                        csf = new MQRMIClientSocketFactory(jmxHostname, brokerHostTrusted, useSSL);
                        env.put("jmx.remote.rmi.client.socket.factory", csf);
                    } else {
                        SslRMIClientSocketFactory sslcf = new SslRMIClientSocketFactory();
                        env.put("jmx.remote.rmi.client.socket.factory", sslcf);
                        if ((Globals.isJMSRAManagedBroker() || Globals.isNucleusManagedBroker()) && this.agent.useRmiRegistry()) {
                            env.put("com.sun.jndi.rmi.factory.socket", sslcf);
                        }
                    }
                }
            }
            cs = JMXConnectorServerFactory.newJMXConnectorServer(this.configuredURL, env, mbs);
        }
        catch (Exception e) {
            throw new BrokerException(this.rb.getString("B2162", this.name), e);
        }
        cs.addNotificationListener(this.listener, null, this);
        this.connectorServer = cs;
    }
}

