/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.types;

import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.SQLBit;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.shared.common.error.StandardException;

public class SQLVarbit
extends SQLBit {
    @Override
    public String getTypeName() {
        return "VARCHAR () FOR BIT DATA";
    }

    @Override
    int getMaxMemoryUsage() {
        return 32672;
    }

    @Override
    public DataValueDescriptor getNewNull() {
        return new SQLVarbit();
    }

    @Override
    public int getTypeFormatId() {
        return 88;
    }

    @Override
    public void normalize(DataTypeDescriptor dataTypeDescriptor, DataValueDescriptor dataValueDescriptor) throws StandardException {
        int n = dataTypeDescriptor.getMaximumWidth();
        byte[] byArray = dataValueDescriptor.getBytes();
        this.setValue(byArray);
        if (byArray.length > n) {
            this.setWidth(n, 0, true);
        }
    }

    @Override
    public void setWidth(int n, int n2, boolean bl) throws StandardException {
        if (this.getValue() == null) {
            return;
        }
        int n3 = this.dataValue.length;
        if (n3 > n) {
            if (bl) {
                for (int i = n; i < this.dataValue.length; ++i) {
                    if (this.dataValue[i] == 32) continue;
                    throw StandardException.newException("22001", this.getTypeName(), StringUtil.formatForPrint(this.toString()), String.valueOf(n));
                }
            }
            this.truncate(n3, n, !bl);
        }
    }

    public SQLVarbit() {
    }

    public SQLVarbit(byte[] byArray) {
        super(byArray);
    }

    @Override
    public int typePrecedence() {
        return 150;
    }
}

