/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.annotation.handlers;

import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.annotation.context.EjbBundleContext;
import com.sun.enterprise.deployment.annotation.context.EjbContext;
import com.sun.enterprise.deployment.annotation.context.EjbInterceptorContext;
import com.sun.enterprise.deployment.annotation.context.ResourceContainerContext;
import com.sun.enterprise.deployment.annotation.context.WebBundleContext;
import com.sun.enterprise.deployment.annotation.context.WebComponentContext;
import com.sun.enterprise.deployment.annotation.context.WebComponentsContext;
import jakarta.interceptor.AroundInvoke;
import jakarta.interceptor.AroundTimeout;
import jakarta.interceptor.Interceptors;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collection;
import org.glassfish.deployment.common.RootDeploymentDescriptor;

public final class ResourceAnnotationControl {
    private static final System.Logger LOG = System.getLogger(ResourceAnnotationControl.class.getName());
    private final String annotationName;

    public ResourceAnnotationControl(Class<?> annotationClass) {
        this.annotationName = annotationClass.getSimpleName();
    }

    public boolean canProcessAnnotation(Class<?> annotatedClass, boolean ejbClass, boolean warClass, ResourceContainerContext context) {
        LOG.log(System.Logger.Level.DEBUG, "canProcessAnnotation(annotatedClass={0}, ejbClass={1}, warClass={2}, context.class={3})", annotatedClass, ejbClass, warClass, context.getClass());
        if (ejbClass) {
            if (!(context instanceof EjbBundleContext || context instanceof EjbContext || context instanceof EjbInterceptorContext)) {
                LOG.log(System.Logger.Level.DEBUG, "Ignoring @{0} annotation processing as the class is an EJB class and context {1} is not one of supported contexts.", this.annotationName, context.getClass());
                return false;
            }
        } else if (context instanceof EjbBundleContext) {
            EjbBundleContext ejbContext = (EjbBundleContext)context;
            Object ejbBundleDescriptor = ejbContext.getDescriptor();
            EjbDescriptor[] ejbDescriptors = ((EjbBundleDescriptor)ejbBundleDescriptor).getEjbByClassName(annotatedClass.getName());
            if (ejbDescriptors.length == 0) {
                LOG.log(System.Logger.Level.DEBUG, "Ignoring @{0} annotation processing as the {1} is not an EJB class and the context is EJBContext", this.annotationName, annotatedClass);
                return false;
            }
        } else if (warClass) {
            if (!(context instanceof WebBundleContext || context instanceof WebComponentsContext || context instanceof WebComponentContext)) {
                LOG.log(System.Logger.Level.DEBUG, "Ignoring @{0} annotation processing as the class is a Web class and context is not one of WebContext", this.annotationName);
                return false;
            }
        } else if (context instanceof WebBundleContext) {
            WebBundleContext webBundleContext = (WebBundleContext)context;
            WebBundleDescriptor webBundleDescriptor = webBundleContext.getDescriptor();
            Collection extDesc = webBundleDescriptor.getExtensionsDescriptors();
            for (RootDeploymentDescriptor desc : extDesc) {
                Method[] methods;
                if (!(desc instanceof EjbBundleDescriptor)) continue;
                EjbBundleDescriptor ejbBundleDesc = (EjbBundleDescriptor)desc;
                EjbDescriptor[] ejbDescs = ejbBundleDesc.getEjbByClassName(annotatedClass.getName());
                if (ejbDescs.length > 0) {
                    LOG.log(System.Logger.Level.DEBUG, "Ignoring @{0} annotation processing as the {1} is not a Web class and the context is WebContext", this.annotationName, annotatedClass);
                    return false;
                }
                if (ejbBundleDesc.getInterceptorByClassName(annotatedClass.getName()) != null) {
                    LOG.log(System.Logger.Level.DEBUG, "Ignoring @{0} annotation processing as the {1} is not a Web class and the context is WebContext", this.annotationName, annotatedClass);
                    return false;
                }
                for (Method method : methods = annotatedClass.getDeclaredMethods()) {
                    Annotation[] annotations;
                    for (Annotation annotation : annotations = method.getAnnotations()) {
                        if (!annotation.annotationType().equals(AroundInvoke.class) && !annotation.annotationType().equals(AroundTimeout.class) && !annotation.annotationType().equals(Interceptors.class)) continue;
                        LOG.log(System.Logger.Level.DEBUG, "Ignoring @{0} annotation processing as the {1} is not a Web class or an interceptor and the context is WebContext", this.annotationName, annotatedClass);
                        return false;
                    }
                }
            }
        }
        return true;
    }
}

