/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.enterprise.concurrent.internal;

import jakarta.enterprise.concurrent.LastExecution;
import jakarta.enterprise.concurrent.SkippedException;
import jakarta.enterprise.concurrent.Trigger;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.concurrent.Callable;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.RunnableScheduledFuture;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import org.glassfish.enterprise.concurrent.AbstractManagedExecutorService;
import org.glassfish.enterprise.concurrent.AbstractManagedThread;
import org.glassfish.enterprise.concurrent.internal.ManagedFutureTask;
import org.glassfish.enterprise.concurrent.internal.ThreadExpiredException;
import org.glassfish.enterprise.concurrent.internal.Util;

public class ManagedScheduledThreadPoolExecutor
extends ScheduledThreadPoolExecutor {
    private long threadLifeTime = 0L;
    private static final AtomicLong sequencer = new AtomicLong(0L);

    public ManagedScheduledThreadPoolExecutor(int corePoolSize) {
        super(corePoolSize);
    }

    public ManagedScheduledThreadPoolExecutor(int corePoolSize, ThreadFactory threadFactory) {
        super(corePoolSize, threadFactory);
    }

    public ManagedScheduledThreadPoolExecutor(int corePoolSize, RejectedExecutionHandler handler) {
        super(corePoolSize, handler);
    }

    public ManagedScheduledThreadPoolExecutor(int corePoolSize, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        super(corePoolSize, threadFactory, handler);
    }

    public void setThreadLifeTime(long threadLifeTime) {
        long keepAliveTime;
        this.threadLifeTime = threadLifeTime;
        if (threadLifeTime > 0L && ((keepAliveTime = this.getKeepAliveTime(TimeUnit.SECONDS)) == 0L || threadLifeTime < keepAliveTime)) {
            this.setKeepAliveTime(threadLifeTime, TimeUnit.SECONDS);
        }
    }

    final long now() {
        return System.nanoTime();
    }

    private long overflowFree(long delay) {
        long headDelay;
        Delayed head = (Delayed)super.getQueue().peek();
        if (head != null && (headDelay = head.getDelay(TimeUnit.NANOSECONDS)) < 0L && delay - headDelay < 0L) {
            delay = Long.MAX_VALUE + headDelay;
        }
        return delay;
    }

    private long triggerTime(long delay, TimeUnit unit) {
        return this.triggerTime(unit.toNanos(delay < 0L ? 0L : delay));
    }

    long triggerTime(long delay) {
        return this.now() + (delay < 0x3FFFFFFFFFFFFFFFL ? delay : this.overflowFree(delay));
    }

    boolean canRunInCurrentRunState(boolean periodic) {
        return !this.isShutdown();
    }

    void ensurePrestart() {
        if (this.getCorePoolSize() == 0) {
            this.setCorePoolSize(1);
        }
        this.prestartCoreThread();
    }

    void reExecutePeriodic(RunnableScheduledFuture<?> task) {
        if (this.canRunInCurrentRunState(true)) {
            super.getQueue().add(task);
            if (!this.canRunInCurrentRunState(true) && this.remove(task)) {
                task.cancel(false);
            } else {
                this.ensurePrestart();
            }
        }
    }

    final void reject(Runnable command) {
        RejectedExecutionHandler handler = this.getRejectedExecutionHandler();
        if (handler != null) {
            handler.rejectedExecution(command, this);
        }
    }

    private void delayedExecute(ManagedScheduledFutureTask<?> task) {
        task.submitted();
        if (this.isShutdown()) {
            this.reject(task);
        } else {
            super.getQueue().add(task);
            if (this.isShutdown() && !this.canRunInCurrentRunState(task.isPeriodic()) && this.remove(task)) {
                task.cancel(false);
            } else {
                this.ensurePrestart();
            }
        }
    }

    @Override
    public void execute(Runnable command) {
        this.schedule(command, 0L, TimeUnit.NANOSECONDS);
    }

    public <V> ScheduledFuture<V> schedule(AbstractManagedExecutorService executor, Runnable command, V result, long delay, TimeUnit unit) {
        if (command == null || unit == null) {
            throw new NullPointerException();
        }
        ManagedScheduledFutureTask<V> t = new ManagedScheduledFutureTask<V>(executor, command, result, this.triggerTime(delay, unit));
        this.delayedExecute(t);
        return t;
    }

    public <V> ScheduledFuture<V> schedule(AbstractManagedExecutorService executor, Callable<V> callable, long delay, TimeUnit unit) {
        if (callable == null || unit == null) {
            throw new NullPointerException();
        }
        ManagedScheduledFutureTask<V> t = new ManagedScheduledFutureTask<V>(executor, callable, this.triggerTime(delay, unit));
        this.delayedExecute(t);
        return t;
    }

    public ScheduledFuture<?> schedule(AbstractManagedExecutorService executor, Runnable command, Trigger trigger) {
        if (command == null) {
            throw new NullPointerException();
        }
        return new TriggerControllerFuture<Object>(executor, command, null, trigger);
    }

    public <V> ScheduledFuture<V> schedule(AbstractManagedExecutorService executor, Callable<V> callable, Trigger trigger) {
        if (callable == null) {
            throw new NullPointerException();
        }
        return new TriggerControllerFuture<V>(executor, callable, trigger);
    }

    public ScheduledFuture<?> scheduleAtFixedRate(AbstractManagedExecutorService executor, Runnable command, long initialDelay, long period, TimeUnit unit) {
        if (command == null || unit == null) {
            throw new NullPointerException();
        }
        if (period <= 0L) {
            throw new IllegalArgumentException();
        }
        ManagedScheduledFutureTask<Object> t = new ManagedScheduledFutureTask<Object>(executor, command, null, this.triggerTime(initialDelay, unit), unit.toNanos(period));
        this.delayedExecute(t);
        return t;
    }

    public ScheduledFuture<?> scheduleWithFixedDelay(AbstractManagedExecutorService executor, Runnable command, long initialDelay, long delay, TimeUnit unit) {
        if (command == null || unit == null) {
            throw new NullPointerException();
        }
        if (delay <= 0L) {
            throw new IllegalArgumentException();
        }
        ManagedScheduledFutureTask<Object> t = new ManagedScheduledFutureTask<Object>(executor, command, null, this.triggerTime(initialDelay, unit), unit.toNanos(-delay));
        this.delayedExecute(t);
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        super.afterExecute(r, t);
        ManagedScheduledFutureTask task = (ManagedScheduledFutureTask)r;
        try {
            task.done(t);
        }
        finally {
            Thread thread;
            task.resetContext();
            if (this.threadLifeTime > 0L && (thread = Thread.currentThread()) instanceof AbstractManagedThread) {
                long threadStartTime = ((AbstractManagedThread)thread).getThreadStartTime();
                if ((System.currentTimeMillis() - threadStartTime) / 1000L > this.threadLifeTime) {
                    throw new ThreadExpiredException();
                }
            }
        }
    }

    @Override
    protected void beforeExecute(Thread t, Runnable r) {
        super.beforeExecute(t, r);
        ManagedFutureTask task = (ManagedFutureTask)r;
        task.setupContext();
        task.starting(t);
    }

    public <V> ManagedFutureTask<V> newTaskFor(AbstractManagedExecutorService executor, Runnable r, V result) {
        return new ManagedScheduledFutureTask<V>(executor, r, result, 0L);
    }

    public ManagedFutureTask newTaskFor(AbstractManagedExecutorService executor, Callable callable) {
        return new ManagedScheduledFutureTask(executor, callable, 0L);
    }

    public void executeManagedTask(ManagedFutureTask task) {
        if (task instanceof ManagedScheduledFutureTask) {
            this.delayedExecute((ManagedScheduledFutureTask)task);
        } else {
            this.schedule(task.executor, task, null, 0L, TimeUnit.NANOSECONDS);
        }
    }

    private class ManagedScheduledFutureTask<V>
    extends ManagedFutureTask<V>
    implements RunnableScheduledFuture<V> {
        protected final long sequenceNumber;
        protected long nextRunTime;
        private final long period;
        RunnableScheduledFuture<V> outerTask;
        int heapIndex;

        ManagedScheduledFutureTask(AbstractManagedExecutorService executor, Runnable r, V result, long ns) {
            this(executor, r, result, ns, 0L);
        }

        ManagedScheduledFutureTask(AbstractManagedExecutorService executor, Callable<V> callable, long ns) {
            this(executor, callable, ns, 0L);
        }

        ManagedScheduledFutureTask(AbstractManagedExecutorService executor, Runnable r, V result, long ns, long period) {
            super(executor, r, result);
            this.outerTask = this;
            this.nextRunTime = ns;
            this.period = period;
            this.sequenceNumber = sequencer.getAndIncrement();
        }

        public ManagedScheduledFutureTask(AbstractManagedExecutorService executor, Callable callable, long ns, long period) {
            super(executor, callable);
            this.outerTask = this;
            this.nextRunTime = ns;
            this.period = period;
            this.sequenceNumber = sequencer.getAndIncrement();
        }

        @Override
        public long getDelay(TimeUnit unit) {
            return unit.convert(this.nextRunTime - ManagedScheduledThreadPoolExecutor.this.now(), TimeUnit.NANOSECONDS);
        }

        @Override
        public int compareTo(Delayed other) {
            if (other == this) {
                return 0;
            }
            if (other instanceof ManagedScheduledFutureTask) {
                ManagedScheduledFutureTask x = (ManagedScheduledFutureTask)other;
                long diff = this.nextRunTime - x.nextRunTime;
                if (diff < 0L) {
                    return -1;
                }
                if (diff > 0L) {
                    return 1;
                }
                if (this.sequenceNumber < x.sequenceNumber) {
                    return -1;
                }
                return 1;
            }
            long d = this.getDelay(TimeUnit.NANOSECONDS) - other.getDelay(TimeUnit.NANOSECONDS);
            return d == 0L ? 0 : (d < 0L ? -1 : 1);
        }

        public boolean equals(Object other) {
            if (other instanceof ManagedScheduledFutureTask) {
                return this.compareTo((ManagedScheduledFutureTask)other) == 0;
            }
            return false;
        }

        public int hashCode() {
            return (int)(this.sequenceNumber ^ this.sequenceNumber >>> 32);
        }

        @Override
        public boolean isPeriodic() {
            return this.period != 0L;
        }

        private void setNextRunTime() {
            long p = this.period;
            this.nextRunTime = p > 0L ? (this.nextRunTime += p) : ManagedScheduledThreadPoolExecutor.this.triggerTime(-p);
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            boolean cancelled = super.cancel(mayInterruptIfRunning);
            if (cancelled && ManagedScheduledThreadPoolExecutor.this.getRemoveOnCancelPolicy() && this.heapIndex >= 0) {
                ManagedScheduledThreadPoolExecutor.this.remove(this);
            }
            return cancelled;
        }

        @Override
        public void run() {
            boolean periodic = this.isPeriodic();
            if (!ManagedScheduledThreadPoolExecutor.this.canRunInCurrentRunState(periodic)) {
                this.cancel(false);
            } else if (!periodic) {
                ManagedScheduledFutureTask.super.run();
            } else if (ManagedScheduledFutureTask.super.runAndReset()) {
                this.setNextRunTime();
                ManagedScheduledThreadPoolExecutor.this.reExecutePeriodic(this.outerTask);
            }
        }
    }

    private class TriggerControllerFuture<V>
    extends ManagedFutureTask<V>
    implements ScheduledFuture<V> {
        private final Trigger trigger;
        private final Date taskScheduledTime;
        private final Callable callable;
        private volatile ManagedTriggerSingleFutureTask<V> currentFuture;
        private volatile LastExecution lastExecution;
        private boolean skipped;
        private ReentrantLock lock;

        public TriggerControllerFuture(AbstractManagedExecutorService executor, Callable<V> callable, Trigger trigger) {
            super(executor, callable);
            this.lock = new ReentrantLock();
            this.trigger = trigger;
            this.callable = callable;
            this.taskScheduledTime = new Date(System.currentTimeMillis());
            this.scheduleNextRun();
            this.submitted();
        }

        public TriggerControllerFuture(AbstractManagedExecutorService executor, Runnable runnable, V result, Trigger trigger) {
            super(executor, runnable, result);
            this.lock = new ReentrantLock();
            this.trigger = trigger;
            this.callable = Executors.callable(runnable);
            this.taskScheduledTime = new Date(System.currentTimeMillis());
            this.scheduleNextRun();
            this.submitted();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void scheduleNextRun() {
            if (this.isDone()) {
                return;
            }
            Date nextRunTime = this.trigger.getNextRunTime(this.lastExecution, this.taskScheduledTime);
            if (nextRunTime == null) {
                this.done(null);
                this.set(null);
                return;
            }
            long ns = ManagedScheduledThreadPoolExecutor.this.triggerTime(nextRunTime.getTime() - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
            try {
                this.lock.lock();
                ManagedTriggerSingleFutureTask future = new ManagedTriggerSingleFutureTask(this.executor, this.callable, ns, nextRunTime.getTime(), this);
                ManagedScheduledThreadPoolExecutor.this.delayedExecute(future);
                this.currentFuture = future;
            }
            finally {
                this.lock.unlock();
            }
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            super.cancel(mayInterruptIfRunning);
            ManagedTriggerSingleFutureTask<V> future = this.getCurrentFuture();
            if (future != null) {
                boolean alreadyDone = future.isDone();
                return future.cancel(mayInterruptIfRunning) || alreadyDone;
            }
            return true;
        }

        @Override
        public V get() throws InterruptedException, ExecutionException {
            if (this.skipped) {
                throw new SkippedException();
            }
            return this.getCurrentFuture().get();
        }

        @Override
        public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            if (this.skipped) {
                throw new SkippedException();
            }
            return this.getCurrentFuture().get(timeout, unit);
        }

        boolean skipRun(Date scheduledRunTime) {
            boolean skip = this.trigger.skipRun(this.lastExecution, scheduledRunTime);
            if (skip) {
                this.scheduleNextRun();
            }
            this.skipped = skip;
            return skip;
        }

        void doneExecution(V result, long scheduledStart, long runStart, long runEnd) {
            this.lastExecution = new LastExecutionImpl<V>(result, scheduledStart, runStart, runEnd);
            this.scheduleNextRun();
        }

        @Override
        public long getDelay(TimeUnit unit) {
            return this.getCurrentFuture().getDelay(unit);
        }

        @Override
        public int compareTo(Delayed o) {
            return this.getCurrentFuture().compareTo(o);
        }

        public boolean equals(Object other) {
            if (other instanceof TriggerControllerFuture) {
                return this.compareTo((TriggerControllerFuture)other) == 0;
            }
            return false;
        }

        private ManagedTriggerSingleFutureTask<V> getCurrentFuture() {
            try {
                this.lock.lock();
                ManagedTriggerSingleFutureTask<V> managedTriggerSingleFutureTask = this.currentFuture;
                return managedTriggerSingleFutureTask;
            }
            finally {
                this.lock.unlock();
            }
        }

        private class LastExecutionImpl<V>
        implements LastExecution {
            private V result;
            private ZonedDateTime scheduledStart;
            private ZonedDateTime runStart;
            private ZonedDateTime runEnd;

            public LastExecutionImpl(V result, long scheduledStart, long runStart, long runEnd) {
                this.result = result;
                this.scheduledStart = scheduledStart == 0L ? null : ZonedDateTime.ofInstant(Instant.ofEpochMilli(scheduledStart), ZoneId.systemDefault());
                this.runStart = runStart == 0L ? null : ZonedDateTime.ofInstant(Instant.ofEpochMilli(runStart), ZoneId.systemDefault());
                this.runEnd = runEnd == 0L ? null : ZonedDateTime.ofInstant(Instant.ofEpochMilli(runEnd), ZoneId.systemDefault());
            }

            public String getIdentityName() {
                return Util.getIdentityName(TriggerControllerFuture.this.task);
            }

            public Object getResult() {
                return this.result;
            }

            public ZonedDateTime getScheduledStart(ZoneId zone) {
                return this.scheduledStart.withZoneSameInstant(zone);
            }

            public ZonedDateTime getRunStart(ZoneId zone) {
                return this.runStart.withZoneSameInstant(zone);
            }

            public ZonedDateTime getRunEnd(ZoneId zone) {
                return this.runEnd.withZoneSameInstant(zone);
            }
        }
    }

    private class ManagedTriggerSingleFutureTask<V>
    extends ManagedScheduledFutureTask<V> {
        private TriggerControllerFuture controller;
        private final long scheduledRunTime;

        ManagedTriggerSingleFutureTask(AbstractManagedExecutorService executor, Callable<V> callable, long ns, long scheduledRunTime, TriggerControllerFuture controller) {
            super(executor, callable, ns);
            this.controller = controller;
            this.scheduledRunTime = scheduledRunTime;
        }

        ManagedTriggerSingleFutureTask(AbstractManagedExecutorService executor, Runnable r, long ns, long scheduledRunTime, TriggerControllerFuture controller) {
            super(executor, r, null, ns);
            this.controller = controller;
            this.scheduledRunTime = scheduledRunTime;
        }

        private long getDelayFromDate(Date nextRunTime) {
            return ManagedScheduledThreadPoolExecutor.this.triggerTime(nextRunTime.getTime() - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
        }

        @Override
        public boolean isPeriodic() {
            return false;
        }

        @Override
        public void run() {
            if (this.controller.skipRun(new Date(this.scheduledRunTime))) {
                return;
            }
            long lastRunStartTime = System.currentTimeMillis();
            Object lastResult = null;
            try {
                super.run();
                lastResult = this.get();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            long lastRunEndTime = System.currentTimeMillis();
            this.controller.doneExecution(lastResult, this.scheduledRunTime, lastRunStartTime, lastRunEndTime);
        }

        @Override
        public void starting(Thread t) {
            this.controller.starting(t);
        }
    }
}

