/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.jdbc;

import java.security.Permission;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Logger;
import org.apache.derby.iapi.jdbc.AuthenticationService;
import org.apache.derby.iapi.jdbc.AutoloadedDriver;
import org.apache.derby.iapi.jdbc.BrokeredConnection;
import org.apache.derby.iapi.jdbc.BrokeredConnectionControl;
import org.apache.derby.iapi.jdbc.ConnectionContext;
import org.apache.derby.iapi.jdbc.JDBC;
import org.apache.derby.iapi.security.SecurityUtil;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.io.FormatableProperties;
import org.apache.derby.iapi.services.jmx.ManagementService;
import org.apache.derby.iapi.services.monitor.ModuleControl;
import org.apache.derby.iapi.services.monitor.ModuleFactory;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.sql.ResultColumnDescriptor;
import org.apache.derby.iapi.sql.ResultSet;
import org.apache.derby.iapi.util.InterruptStatus;
import org.apache.derby.impl.jdbc.EmbedCallableStatement;
import org.apache.derby.impl.jdbc.EmbedConnection;
import org.apache.derby.impl.jdbc.EmbedDatabaseMetaData;
import org.apache.derby.impl.jdbc.EmbedPreparedStatement;
import org.apache.derby.impl.jdbc.EmbedResultSet;
import org.apache.derby.impl.jdbc.EmbedResultSetMetaData;
import org.apache.derby.impl.jdbc.EmbedStatement;
import org.apache.derby.impl.jdbc.Util;
import org.apache.derby.mbeans.JDBCMBean;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.i18n.MessageService;

public class InternalDriver
implements ModuleControl,
Driver {
    private static final Object syncMe = new Object();
    private static InternalDriver activeDriver;
    private Object mbean;
    protected boolean active;
    private ContextService contextServiceFactory = InternalDriver.getContextService();
    private AuthenticationService authenticationService;
    private static boolean deregister;
    private static final ExecutorService _executorPool;
    private static final String[] BOOLEAN_CHOICES;

    public static final InternalDriver activeDriver() {
        return activeDriver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void boot(boolean bl, Properties properties) throws StandardException {
        Object object = syncMe;
        synchronized (object) {
            activeDriver = this;
        }
        this.active = true;
        this.mbean = ((ManagementService)InternalDriver.getSystemModule("org.apache.derby.iapi.services.jmx.ManagementService")).registerMBean(new JDBC(this), JDBCMBean.class, "type=JDBC");
        AutoloadedDriver.registerDriverModule(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        Object object = syncMe;
        synchronized (object) {
            activeDriver = null;
        }
        ((ManagementService)InternalDriver.getSystemModule("org.apache.derby.iapi.services.jmx.ManagementService")).unregisterMBean(this.mbean);
        this.active = false;
        this.contextServiceFactory = null;
        AutoloadedDriver.unregisterDriverModule();
    }

    @Override
    public boolean acceptsURL(String string) throws SQLException {
        return this.active && InternalDriver.embeddedDriverAcceptsURL(string);
    }

    public static boolean embeddedDriverAcceptsURL(String string) throws SQLException {
        if (string == null) {
            throw Util.generateCsSQLException("XJ028.C", "null");
        }
        return !string.startsWith("jdbc:derby:net:") && !string.startsWith("jdbc:derby://") && (string.startsWith("jdbc:derby:") || string.equals("jdbc:default:connection"));
    }

    public Connection connect(String string, Properties properties, int n) throws SQLException {
        if (!this.acceptsURL(string)) {
            return null;
        }
        if (EmbedConnection.memoryState.isLowMemory()) {
            throw EmbedConnection.NO_MEM;
        }
        boolean bl = string.equals("jdbc:default:connection");
        if (bl) {
            ConnectionContext connectionContext = this.getConnectionContext();
            if (connectionContext != null) {
                return connectionContext.getNestedConnection(false);
            }
            return null;
        }
        FormatableProperties formatableProperties = null;
        try {
            formatableProperties = this.getAttributes(string, properties);
            properties = null;
            boolean bl2 = Boolean.valueOf(formatableProperties.getProperty("shutdown"));
            if (bl2 && InternalDriver.getDatabaseName(string, formatableProperties).length() == 0) {
                if (this.getAuthenticationService() == null) {
                    throw Util.generateCsSQLException("08004", MessageService.getTextMessage("A001", new Object[0]));
                }
                if (!this.getAuthenticationService().authenticate(null, formatableProperties)) {
                    throw Util.generateCsSQLException("08004.C.1", MessageService.getTextMessage("A020", new Object[0]));
                }
                if (formatableProperties.getProperty("deregister") != null) {
                    boolean bl3 = Boolean.valueOf(formatableProperties.getProperty("deregister"));
                    InternalDriver.setDeregister(bl3);
                }
                InternalDriver.getMonitor().shutdown();
                throw Util.generateCsSQLException("XJ015.M", new Object[0]);
            }
            EmbedConnection embedConnection = n <= 0 ? this.getNewEmbedConnection(string, formatableProperties) : this.timeLogin(string, formatableProperties, n);
            if (embedConnection.isClosed()) {
                Connection connection = null;
                return connection;
            }
            EmbedConnection embedConnection2 = embedConnection;
            return embedConnection2;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            EmbedConnection.memoryState.setLowMemory();
            throw EmbedConnection.NO_MEM;
        }
        finally {
            if (formatableProperties != null) {
                formatableProperties.clearDefaults();
            }
        }
    }

    private EmbedConnection timeLogin(String string, Properties properties, int n) throws SQLException {
        try {
            LoginCallable loginCallable = new LoginCallable(this, string, properties);
            Future<EmbedConnection> future = _executorPool.submit(loginCallable);
            long l = System.currentTimeMillis();
            long l2 = l + (long)n * 1000L;
            while (l < l2) {
                try {
                    EmbedConnection embedConnection = future.get(l2 - l, TimeUnit.MILLISECONDS);
                    return embedConnection;
                }
                catch (InterruptedException interruptedException) {
                    InterruptStatus.setInterrupted();
                    l = System.currentTimeMillis();
                }
                catch (ExecutionException executionException) {
                    throw this.processException(executionException);
                }
                catch (TimeoutException timeoutException) {
                    throw Util.generateCsSQLException("XBDA0.C.1", new Object[0]);
                }
            }
            throw Util.generateCsSQLException("XBDA0.C.1", new Object[0]);
        }
        finally {
            InterruptStatus.restoreIntrFlagIfSeen();
        }
    }

    private SQLException processException(Throwable throwable) {
        Throwable throwable2 = throwable.getCause();
        if (throwable2 instanceof SQLException) {
            return (SQLException)throwable2;
        }
        return Util.javaException(throwable);
    }

    public void checkSystemPrivileges(String string, Permission permission) {
        SecurityUtil.checkUserHasPermission(string, permission);
    }

    private void checkShutdownPrivileges(String string) throws SQLException {
    }

    @Override
    public int getMajorVersion() {
        return InternalDriver.getMonitor().getEngineVersion().getMajorVersion();
    }

    @Override
    public int getMinorVersion() {
        return InternalDriver.getMonitor().getEngineVersion().getMinorVersion();
    }

    @Override
    public boolean jdbcCompliant() {
        return true;
    }

    protected FormatableProperties getAttributes(String string, Properties properties) throws SQLException {
        FormatableProperties formatableProperties = new FormatableProperties(properties);
        properties = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        stringTokenizer.nextToken();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            int n = string2.indexOf(61);
            if (n == -1) {
                throw Util.generateCsSQLException("XJ028.C", string);
            }
            formatableProperties.put(string2.substring(0, n).trim(), string2.substring(n + 1).trim());
        }
        InternalDriver.checkBoolean(formatableProperties, "dataEncryption");
        InternalDriver.checkBoolean(formatableProperties, "create");
        InternalDriver.checkBoolean(formatableProperties, "shutdown");
        InternalDriver.checkBoolean(formatableProperties, "deregister");
        InternalDriver.checkBoolean(formatableProperties, "upgrade");
        return formatableProperties;
    }

    private static void checkBoolean(Properties properties, String string) throws SQLException {
        String[] stringArray = new String[]{"true", "false"};
        InternalDriver.checkEnumeration(properties, string, stringArray);
    }

    private static void checkEnumeration(Properties properties, String string, String[] stringArray) throws SQLException {
        String string2 = properties.getProperty(string);
        if (string2 == null) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string2.toUpperCase(Locale.ENGLISH).equals(stringArray[i].toUpperCase(Locale.ENGLISH))) continue;
            return;
        }
        Object object = "{";
        for (int i = 0; i < stringArray.length; ++i) {
            if (i > 0) {
                object = (String)object + "|";
            }
            object = (String)object + stringArray[i];
        }
        throw Util.generateCsSQLException("XJ05B.C", string, string2, (String)object + "}");
    }

    public static String getDatabaseName(String string, Properties properties) {
        if (string.equals("jdbc:default:connection")) {
            return "";
        }
        int n = string.indexOf(59);
        String string2 = n == -1 ? string.substring("jdbc:derby:".length()) : string.substring("jdbc:derby:".length(), n);
        if (string2.length() == 0 && properties != null) {
            string2 = properties.getProperty("databaseName", string2);
        }
        string2 = string2.trim();
        return string2;
    }

    public final ContextService getContextServiceFactory() {
        return this.contextServiceFactory;
    }

    public AuthenticationService getAuthenticationService() {
        if (this.authenticationService == null) {
            this.authenticationService = (AuthenticationService)InternalDriver.findService("org.apache.derby.iapi.jdbc.AuthenticationService", "authentication");
        }
        return this.authenticationService;
    }

    EmbedConnection getNewEmbedConnection(String string, Properties properties) throws SQLException {
        InternalDriver internalDriver = this;
        return new EmbedConnection(internalDriver, string, properties);
    }

    private ConnectionContext getConnectionContext() {
        ContextManager contextManager = this.getCurrentContextManager();
        ConnectionContext connectionContext = null;
        if (contextManager != null) {
            connectionContext = (ConnectionContext)((Object)contextManager.getContext("JDBC_ConnectionContext"));
        }
        return connectionContext;
    }

    private ContextManager getCurrentContextManager() {
        return this.getContextServiceFactory().getCurrentContextManager();
    }

    public boolean isActive() {
        return this.active;
    }

    public Connection getNewNestedConnection(EmbedConnection embedConnection) {
        return new EmbedConnection(embedConnection);
    }

    public Statement newEmbedStatement(EmbedConnection embedConnection, boolean bl, int n, int n2, int n3) {
        return new EmbedStatement(embedConnection, bl, n, n2, n3);
    }

    public PreparedStatement newEmbedPreparedStatement(EmbedConnection embedConnection, String string, boolean bl, int n, int n2, int n3, int n4, int[] nArray, String[] stringArray) throws SQLException {
        return new EmbedPreparedStatement(embedConnection, string, bl, n, n2, n3, n4, nArray, stringArray);
    }

    public CallableStatement newEmbedCallableStatement(EmbedConnection embedConnection, String string, int n, int n2, int n3) throws SQLException {
        return new EmbedCallableStatement(embedConnection, string, n, n2, n3);
    }

    public DatabaseMetaData newEmbedDatabaseMetaData(EmbedConnection embedConnection, String string) throws SQLException {
        return new EmbedDatabaseMetaData(embedConnection, string);
    }

    public EmbedResultSet newEmbedResultSet(EmbedConnection embedConnection, ResultSet resultSet, boolean bl, EmbedStatement embedStatement, boolean bl2) throws SQLException {
        return new EmbedResultSet(embedConnection, resultSet, bl, embedStatement, bl2);
    }

    public EmbedResultSetMetaData newEmbedResultSetMetaData(ResultColumnDescriptor[] resultColumnDescriptorArray) {
        return new EmbedResultSetMetaData(resultColumnDescriptorArray);
    }

    public BrokeredConnection newBrokeredConnection(BrokeredConnectionControl brokeredConnectionControl) throws SQLException {
        return new BrokeredConnection(brokeredConnectionControl);
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String string, Properties properties) throws SQLException {
        if (properties != null && Boolean.valueOf(properties.getProperty("shutdown")).booleanValue()) {
            return new DriverPropertyInfo[0];
        }
        String string2 = InternalDriver.getDatabaseName(string, properties);
        FormatableProperties formatableProperties = this.getAttributes(string, properties);
        properties = null;
        boolean bl = Boolean.valueOf(formatableProperties.getProperty("dataEncryption"));
        String string3 = formatableProperties.getProperty("bootPassword");
        if (string2.length() == 0 || bl && string3 == null) {
            String[][] stringArrayArray = new String[][]{{"databaseName", "J004"}, {"encryptionProvider", "J016"}, {"encryptionAlgorithm", "J017"}, {"encryptionKeyLength", "J018"}, {"encryptionKey", "J019"}, {"territory", "J021"}, {"collation", "J031"}, {"user", "J022"}, {"logDevice", "J025"}, {"rollForwardRecoveryFrom", "J028"}, {"createFrom", "J029"}, {"restoreFrom", "J030"}};
            String[][] stringArrayArray2 = new String[][]{{"shutdown", "J005"}, {"deregister", "J006"}, {"create", "J007"}, {"dataEncryption", "J010"}, {"upgrade", "J013"}};
            String[][] stringArrayArray3 = new String[][]{{"bootPassword", "J020"}, {"password", "J023"}};
            DriverPropertyInfo[] driverPropertyInfoArray = new DriverPropertyInfo[stringArrayArray.length + stringArrayArray2.length + stringArrayArray3.length];
            int n = 0;
            int n2 = 0;
            while (n2 < stringArrayArray.length) {
                driverPropertyInfoArray[n] = new DriverPropertyInfo(stringArrayArray[n2][0], formatableProperties.getProperty(stringArrayArray[n2][0]));
                driverPropertyInfoArray[n].description = MessageService.getTextMessage(stringArrayArray[n2][1], new Object[0]);
                ++n2;
                ++n;
            }
            driverPropertyInfoArray[0].choices = InternalDriver.getMonitor().getServiceList("org.apache.derby.database.Database");
            driverPropertyInfoArray[0].value = string2;
            n2 = 0;
            while (n2 < stringArrayArray3.length) {
                driverPropertyInfoArray[n] = new DriverPropertyInfo(stringArrayArray3[n2][0], formatableProperties.getProperty(stringArrayArray3[n2][0]) == null ? "" : "****");
                driverPropertyInfoArray[n].description = MessageService.getTextMessage(stringArrayArray3[n2][1], new Object[0]);
                ++n2;
                ++n;
            }
            n2 = 0;
            while (n2 < stringArrayArray2.length) {
                driverPropertyInfoArray[n] = new DriverPropertyInfo(stringArrayArray2[n2][0], Boolean.valueOf(formatableProperties == null ? "" : formatableProperties.getProperty(stringArrayArray2[n2][0])).toString());
                driverPropertyInfoArray[n].description = MessageService.getTextMessage(stringArrayArray2[n2][1], new Object[0]);
                driverPropertyInfoArray[n].choices = BOOLEAN_CHOICES;
                ++n2;
                ++n;
            }
            return driverPropertyInfoArray;
        }
        return new DriverPropertyInfo[0];
    }

    @Override
    public Connection connect(String string, Properties properties) throws SQLException {
        return this.connect(string, properties, DriverManager.getLoginTimeout());
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw (SQLFeatureNotSupportedException)Util.notImplemented("getParentLogger()");
    }

    public static void setDeregister(boolean bl) {
        deregister = bl;
    }

    public static boolean getDeregister() {
        return deregister;
    }

    private static ContextService getContextService() {
        return ContextService.getFactory();
    }

    private static ModuleFactory getMonitor() {
        return Monitor.getMonitor();
    }

    private static Object getSystemModule(String string) {
        return Monitor.getSystemModule(string);
    }

    private static Object findService(String string, String string2) {
        return Monitor.findService(string, string2);
    }

    static {
        deregister = true;
        _executorPool = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 0L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new DaemonThreadFactory());
        BOOLEAN_CHOICES = new String[]{"false", "true"};
    }

    public static final class LoginCallable
    implements Callable<EmbedConnection> {
        private InternalDriver _driver;
        private String _url;
        private Properties _info;

        public LoginCallable(InternalDriver internalDriver, String string, Properties properties) {
            this._driver = internalDriver;
            this._url = string;
            this._info = properties;
        }

        @Override
        public EmbedConnection call() throws SQLException {
            String string = this._url;
            Properties properties = this._info;
            InternalDriver internalDriver = this._driver;
            this._url = null;
            this._info = null;
            this._driver = null;
            return internalDriver.getNewEmbedConnection(string, properties);
        }
    }

    private static final class DaemonThreadFactory
    implements ThreadFactory {
        private DaemonThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(runnable);
            thread.setDaemon(true);
            return thread;
        }
    }
}

