/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.grizzly2.httpserver;

import jakarta.ws.rs.ProcessingException;
import jakarta.ws.rs.core.Application;
import jakarta.ws.rs.core.Configuration;
import java.io.IOException;
import java.net.URI;
import java.util.concurrent.ThreadFactory;
import org.glassfish.grizzly.http.server.HttpHandler;
import org.glassfish.grizzly.http.server.HttpHandlerRegistration;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.grizzly.http.server.NetworkListener;
import org.glassfish.grizzly.http.server.ServerConfiguration;
import org.glassfish.grizzly.ssl.SSLEngineConfigurator;
import org.glassfish.grizzly.utils.Charsets;
import org.glassfish.jersey.grizzly2.httpserver.GrizzlyHttpContainer;
import org.glassfish.jersey.grizzly2.httpserver.internal.LocalizationMessages;
import org.glassfish.jersey.innate.VirtualThreadUtil;
import org.glassfish.jersey.innate.virtual.LoomishExecutors;
import org.glassfish.jersey.internal.guava.ThreadFactoryBuilder;
import org.glassfish.jersey.process.JerseyProcessingUncaughtExceptionHandler;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.ServerConfig;

public final class GrizzlyHttpServerFactory {
    public static HttpServer createHttpServer(URI uri) {
        return GrizzlyHttpServerFactory.createHttpServer(uri, (GrizzlyHttpContainer)null, false, null, true);
    }

    public static HttpServer createHttpServer(URI uri, boolean start) {
        return GrizzlyHttpServerFactory.createHttpServer(uri, (GrizzlyHttpContainer)null, false, null, start);
    }

    public static HttpServer createHttpServer(URI uri, ResourceConfig configuration) {
        return GrizzlyHttpServerFactory.createHttpServer(uri, new GrizzlyHttpContainer((Application)configuration), false, null, true);
    }

    public static HttpServer createHttpServer(URI uri, ResourceConfig configuration, boolean start) {
        return GrizzlyHttpServerFactory.createHttpServer(uri, new GrizzlyHttpContainer((Application)configuration), false, null, start);
    }

    public static HttpServer createHttpServer(URI uri, ResourceConfig configuration, boolean secure, SSLEngineConfigurator sslEngineConfigurator) {
        return GrizzlyHttpServerFactory.createHttpServer(uri, new GrizzlyHttpContainer((Application)configuration), secure, sslEngineConfigurator, true);
    }

    public static HttpServer createHttpServer(URI uri, ResourceConfig configuration, boolean secure, SSLEngineConfigurator sslEngineConfigurator, boolean start) {
        return GrizzlyHttpServerFactory.createHttpServer(uri, new GrizzlyHttpContainer((Application)configuration), secure, sslEngineConfigurator, start);
    }

    public static HttpServer createHttpServer(URI uri, ResourceConfig config, boolean secure, SSLEngineConfigurator sslEngineConfigurator, Object parentContext) {
        return GrizzlyHttpServerFactory.createHttpServer(uri, new GrizzlyHttpContainer((Application)config, parentContext), secure, sslEngineConfigurator, true);
    }

    public static HttpServer createHttpServer(URI uri, ResourceConfig config, boolean secure, SSLEngineConfigurator sslEngineConfigurator, Object parentContext, boolean start) {
        return GrizzlyHttpServerFactory.createHttpServer(uri, new GrizzlyHttpContainer((Application)config, parentContext), secure, sslEngineConfigurator, start);
    }

    public static HttpServer createHttpServer(URI uri, ResourceConfig config, Object parentContext) {
        return GrizzlyHttpServerFactory.createHttpServer(uri, new GrizzlyHttpContainer((Application)config, parentContext), false, null, true);
    }

    public static HttpServer createHttpServer(URI uri, ResourceConfig config, Object parentContext, boolean start) {
        return GrizzlyHttpServerFactory.createHttpServer(uri, new GrizzlyHttpContainer((Application)config, parentContext), false, null, start);
    }

    public static HttpServer createHttpServer(URI uri, GrizzlyHttpContainer handler, boolean secure, SSLEngineConfigurator sslEngineConfigurator, boolean start) {
        String host;
        String string = host = uri.getHost() == null ? "0.0.0.0" : uri.getHost();
        int port = uri.getPort() == -1 ? (secure ? 443 : 80) : uri.getPort();
        NetworkListener listener = new NetworkListener("grizzly", host, port);
        ServerConfig configuration = handler != null ? handler.getConfiguration().getConfiguration() : null;
        LoomishExecutors executors = VirtualThreadUtil.withConfig((Configuration)configuration, (boolean)false);
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("grizzly-http-server-%d").setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new JerseyProcessingUncaughtExceptionHandler()).setThreadFactory(executors.getThreadFactory()).build();
        if (executors.isVirtual()) {
            listener.getTransport().setWorkerThreadPool(executors.newCachedThreadPool());
        } else {
            listener.getTransport().getWorkerThreadPoolConfig().setThreadFactory(threadFactory);
        }
        listener.setSecure(secure);
        if (sslEngineConfigurator != null) {
            listener.setSSLEngineConfig(sslEngineConfigurator);
        }
        HttpServer server = new HttpServer();
        server.addListener(listener);
        ServerConfiguration config = server.getServerConfiguration();
        if (handler != null) {
            String appPath = handler.getApplicationHandler().getConfiguration().getApplicationPath();
            String uriPath = appPath == null ? uri.getPath() : uri.getPath() + "/" + appPath;
            String path = uriPath.replaceAll("/{2,}", "/");
            String contextPath = path.endsWith("/") ? path.substring(0, path.length() - 1) : path;
            config.addHttpHandler((HttpHandler)handler, new HttpHandlerRegistration[]{HttpHandlerRegistration.bulder().contextPath(contextPath).build()});
        }
        config.setPassTraceRequest(true);
        config.setDefaultQueryEncoding(Charsets.UTF8_CHARSET);
        if (start) {
            try {
                server.start();
            }
            catch (IOException ex) {
                server.shutdownNow();
                throw new ProcessingException(LocalizationMessages.FAILED_TO_START_SERVER(ex.getMessage()), (Throwable)ex);
            }
        }
        return server;
    }

    private GrizzlyHttpServerFactory() {
    }
}

