/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.drda;

import java.sql.SQLException;
import java.util.Properties;
import javax.sql.XAConnection;
import javax.transaction.xa.XAResource;
import org.apache.derby.iapi.jdbc.EmbeddedXADataSourceInterface;
import org.apache.derby.iapi.jdbc.EngineConnection;
import org.apache.derby.iapi.jdbc.ResourceAdapter;
import org.apache.derby.impl.drda.Database;
import org.apache.derby.shared.common.i18n.MessageService;
import org.apache.derby.shared.common.info.JVMInfo;

class XADatabase
extends Database {
    private EmbeddedXADataSourceInterface xaDataSource;
    private XAResource xaResource;
    private XAConnection xaConnection;
    private ResourceAdapter ra;

    XADatabase(String string) {
        super(string);
    }

    @Override
    synchronized void makeConnection(Properties properties) throws SQLException {
        Object object;
        if (this.xaDataSource == null) {
            try {
                if (JVMInfo.hasJNDI()) {
                    object = Class.forName("org.apache.derby.jdbc.EmbeddedXADataSource");
                    this.xaDataSource = (EmbeddedXADataSourceInterface)((Class)object).getConstructor(new Class[0]).newInstance(new Object[0]);
                } else {
                    object = Class.forName("org.apache.derby.jdbc.BasicEmbeddedXADataSource40");
                    this.xaDataSource = (EmbeddedXADataSourceInterface)((Class)object).getConstructor(new Class[0]).newInstance(new Object[0]);
                }
            }
            catch (Exception exception) {
                SQLException sQLException = new SQLException(MessageService.getTextMessage("I024", new Object[0]), "08006", 45000);
                sQLException.initCause(exception);
                throw sQLException;
            }
        }
        this.xaDataSource.setDatabaseName(this.getShortDbName());
        this.appendAttrString(properties);
        if (this.attrString != null) {
            this.xaDataSource.setConnectionAttributes(this.attrString);
        }
        if ((object = this.getConnection()) == null) {
            this.xaConnection = this.xaDataSource.getXAConnection(this.userId, this.password);
            this.ra = this.xaDataSource.getResourceAdapter();
            this.setXAResource(this.xaConnection.getXAResource());
        } else {
            object.close();
        }
        object = (EngineConnection)this.xaConnection.getConnection();
        object.setAutoCommit(false);
        this.setConnection((EngineConnection)object);
    }

    protected void setXAResource(XAResource xAResource) {
        this.xaResource = xAResource;
    }

    protected XAResource getXAResource() {
        return this.xaResource;
    }

    ResourceAdapter getResourceAdapter() {
        return this.ra;
    }
}

