/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.expressly.lang;

import jakarta.el.ELContext;
import jakarta.el.ELException;
import jakarta.el.FunctionMapper;
import jakarta.el.MethodExpression;
import jakarta.el.ValueExpression;
import jakarta.el.VariableMapper;
import java.io.StringReader;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentHashMap;
import org.glassfish.expressly.MethodExpressionImpl;
import org.glassfish.expressly.MethodExpressionLiteral;
import org.glassfish.expressly.ValueExpressionImpl;
import org.glassfish.expressly.lang.FunctionMapperFactory;
import org.glassfish.expressly.lang.VariableMapperFactory;
import org.glassfish.expressly.parser.AstCompositeExpression;
import org.glassfish.expressly.parser.AstDeferredExpression;
import org.glassfish.expressly.parser.AstDynamicExpression;
import org.glassfish.expressly.parser.AstFunction;
import org.glassfish.expressly.parser.AstIdentifier;
import org.glassfish.expressly.parser.AstLiteralExpression;
import org.glassfish.expressly.parser.AstMethodArguments;
import org.glassfish.expressly.parser.AstValue;
import org.glassfish.expressly.parser.ELParser;
import org.glassfish.expressly.parser.ELParserTokenManager;
import org.glassfish.expressly.parser.Node;
import org.glassfish.expressly.parser.NodeVisitor;
import org.glassfish.expressly.parser.ParseException;
import org.glassfish.expressly.parser.SimpleCharStream;
import org.glassfish.expressly.util.MessageFactory;

public final class ExpressionBuilder
implements NodeVisitor {
    private static final SoftConcurrentHashMap cache = new SoftConcurrentHashMap();
    private FunctionMapper fnMapper;
    private VariableMapper varMapper;
    private String expression;

    public ExpressionBuilder(String expression, ELContext ctx) throws ELException {
        this.expression = expression;
        FunctionMapper ctxFn = ctx.getFunctionMapper();
        VariableMapper ctxVar = ctx.getVariableMapper();
        if (ctxFn != null) {
            this.fnMapper = new FunctionMapperFactory(ctxFn);
        }
        if (ctxVar != null) {
            this.varMapper = new VariableMapperFactory(ctxVar);
        }
    }

    public static Node createNode(String expr) throws ELException {
        Node n = ExpressionBuilder.createNodeInternal(expr);
        return n;
    }

    private static Node createNodeInternal(String expr) throws ELException {
        if (expr == null) {
            throw new ELException(MessageFactory.get("error.null"));
        }
        Node node = cache.get(expr);
        if (node == null) {
            try {
                node = new ELParser(new ELParserTokenManager(new SimpleCharStream(new StringReader(expr), 1, 1, expr.length() + 1))).CompositeExpression();
                if (node instanceof AstCompositeExpression) {
                    int numChildren = node.jjtGetNumChildren();
                    if (numChildren == 1) {
                        node = node.jjtGetChild(0);
                    } else {
                        Class<?> type = null;
                        Node child = null;
                        for (int i = 0; i < numChildren; ++i) {
                            child = node.jjtGetChild(i);
                            if (child instanceof AstLiteralExpression) continue;
                            if (type == null) {
                                type = child.getClass();
                                continue;
                            }
                            if (type.equals(child.getClass())) continue;
                            throw new ELException(MessageFactory.get("error.mixed", expr));
                        }
                    }
                }
                if (node instanceof AstDeferredExpression || node instanceof AstDynamicExpression) {
                    node = node.jjtGetChild(0);
                }
                cache.putIfAbsent(expr, node);
            }
            catch (ParseException pe) {
                throw new ELException("Error Parsing: " + expr, (Throwable)pe);
            }
        }
        return node;
    }

    private void prepare(Node node) throws ELException {
        node.accept(this);
        if (this.fnMapper instanceof FunctionMapperFactory) {
            this.fnMapper = ((FunctionMapperFactory)this.fnMapper).create();
        }
        if (this.varMapper instanceof VariableMapperFactory) {
            this.varMapper = ((VariableMapperFactory)this.varMapper).create();
        }
    }

    private Node build() throws ELException {
        Node node = ExpressionBuilder.createNodeInternal(this.expression);
        this.prepare(node);
        if (node instanceof AstDeferredExpression || node instanceof AstDynamicExpression) {
            node = node.jjtGetChild(0);
        }
        return node;
    }

    @Override
    public void visit(Node node) throws ELException {
        if (node instanceof AstFunction) {
            AstFunction funcNode = (AstFunction)node;
            if (funcNode.getPrefix().length() == 0 && (this.fnMapper == null || this.fnMapper.resolveFunction(funcNode.getPrefix(), funcNode.getLocalName()) == null)) {
                if (this.varMapper != null) {
                    this.varMapper.resolveVariable(funcNode.getLocalName());
                }
                return;
            }
            if (this.fnMapper == null) {
                throw new ELException(MessageFactory.get("error.fnMapper.null"));
            }
            Method functionMethod = this.fnMapper.resolveFunction(funcNode.getPrefix(), funcNode.getLocalName());
            if (functionMethod == null) {
                throw new ELException(MessageFactory.get("error.fnMapper.method", funcNode.getOutputName()));
            }
            int parameterCount = functionMethod.getParameterCount();
            int argumentCount = ((AstMethodArguments)node.jjtGetChild(0)).getParameterCount();
            if (argumentCount != parameterCount) {
                throw new ELException(MessageFactory.get("error.fnMapper.paramcount", funcNode.getOutputName(), parameterCount, argumentCount));
            }
        } else if (node instanceof AstIdentifier && this.varMapper != null) {
            String variable = ((AstIdentifier)node).getImage();
            this.varMapper.resolveVariable(variable);
        }
    }

    public ValueExpression createValueExpression(Class<?> expectedType) throws ELException {
        return new ValueExpressionImpl(this.expression, this.build(), this.fnMapper, this.varMapper, expectedType);
    }

    public MethodExpression createMethodExpression(Class<?> expectedReturnType, Class<?>[] expectedParamTypes) throws ELException {
        Node node = this.build();
        if (node instanceof AstValue || node instanceof AstIdentifier) {
            return new MethodExpressionImpl(this.expression, node, this.fnMapper, this.varMapper, expectedReturnType, expectedParamTypes);
        }
        if (node instanceof AstLiteralExpression) {
            return new MethodExpressionLiteral(this.expression, expectedReturnType, expectedParamTypes);
        }
        throw new ELException("Not a Valid Method Expression: " + this.expression);
    }

    private static class SoftConcurrentHashMap
    extends ConcurrentHashMap<String, Node> {
        private static final long serialVersionUID = 1L;
        private static final int CACHE_INIT_SIZE = 256;
        private ConcurrentHashMap<String, NodeSoftReference> map = new ConcurrentHashMap(256);
        private ReferenceQueue<Node> refQ = new ReferenceQueue();

        private SoftConcurrentHashMap() {
        }

        private void cleanup() {
            NodeSoftReference nodeRef = null;
            while ((nodeRef = (NodeSoftReference)this.refQ.poll()) != null) {
                this.map.remove(nodeRef.key);
            }
        }

        @Override
        public Node put(String key, Node value) {
            this.cleanup();
            NodeSoftReference prev = this.map.put(key, new NodeSoftReference(key, value, this.refQ));
            return prev == null ? null : (Node)prev.get();
        }

        @Override
        public Node putIfAbsent(String key, Node value) {
            this.cleanup();
            NodeSoftReference prev = this.map.putIfAbsent(key, new NodeSoftReference(key, value, this.refQ));
            return prev == null ? null : (Node)prev.get();
        }

        @Override
        public Node get(Object key) {
            this.cleanup();
            NodeSoftReference nodeRef = this.map.get(key);
            if (nodeRef == null) {
                return null;
            }
            if (nodeRef.get() == null) {
                this.map.remove(key);
                return null;
            }
            return (Node)nodeRef.get();
        }
    }

    private static class NodeSoftReference
    extends SoftReference<Node> {
        final String key;

        NodeSoftReference(String key, Node node, ReferenceQueue<Node> refQ) {
            super(node, refQ);
            this.key = key;
        }
    }
}

