/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.gms.admin;

import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.ee.cms.core.GMSConstants;
import com.sun.enterprise.ee.cms.core.GroupManagementService;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.FailurePolicy;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.admin.Supplemental;
import org.glassfish.api.logging.LogLevel;
import org.glassfish.gms.admin.GMSAnnounceSupplementalInfo;
import org.glassfish.gms.bootstrap.GMSAdapter;
import org.glassfish.gms.bootstrap.GMSAdapterService;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.logging.annotation.LogMessageInfo;
import org.glassfish.logging.annotation.LogMessagesResourceBundle;
import org.glassfish.logging.annotation.LoggerInfo;
import org.jvnet.hk2.annotations.Service;

@Service(name="_gms-announce-before-start-cluster-command")
@Supplemental(value="start-cluster", on=Supplemental.Timing.Before, ifFailure=FailurePolicy.Warn)
@PerLookup
@RestEndpoints(value={@RestEndpoint(configBean=Domain.class, opType=RestEndpoint.OpType.POST, path="_gms-announce-before-start-cluster-command", description="_gms-announce-before-start-cluster-command")})
public class GMSAnnounceBeforeStartClusterCommand
implements AdminCommand {
    @LoggerInfo(subsystem="CLSTR", description="Group Management Service Admin Logger", publish=true)
    private static final String GMS_LOGGER_NAME = "jakarta.enterprise.cluster.gms.admin";
    @LogMessagesResourceBundle
    private static final String LOG_MESSAGES_RB = "org.glassfish.cluster.gms.LogMessages";
    static final Logger GMS_LOGGER = Logger.getLogger("jakarta.enterprise.cluster.gms.admin", "org.glassfish.cluster.gms.LogMessages");
    @LogMessageInfo(message="An exception occurred while announcing GMS group startup: {0}", level="WARNING", cause="An unexpected exception occurred in the GMS implementation.", action="Check the server log file for more information from Shoal-GMS.")
    private static final String GMS_CLUSTER_START_EXCEPTION = "NCLS-CLSTR-30004";
    @Inject
    private ServerEnvironment env;
    @Inject
    private ServiceLocator habitat;
    @Param(optional=false, primary=true)
    private String clusterName;
    @Inject
    private Domain domain;
    @Inject
    private CommandRunner runner;
    @Param(optional=true, defaultValue="false")
    private boolean verbose;
    @Inject
    GMSAdapterService gmsAdapterService;
    private static final List<String> EMPTY_LIST = new LinkedList<String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(AdminCommandContext context) {
        GroupManagementService gms = null;
        GMSAdapter gmsadapter = null;
        boolean gmsStartCluster = false;
        List<String> clusterMembers = EMPTY_LIST;
        ActionReport report = context.getActionReport();
        try {
            List startedGMSMembers;
            if (this.gmsAdapterService.isGmsEnabled() && (gmsadapter = this.gmsAdapterService.getGMSAdapterByName(this.clusterName)) != null && (gms = gmsadapter.getModule()) != null && (clusterMembers = this.getClusterMembers()) != null && clusterMembers.size() > 0 && (startedGMSMembers = gms.getGroupHandle().getCurrentCoreMembers()).size() == 0) {
                try {
                    gms.announceGroupStartup(this.clusterName, GMSConstants.groupStartupState.INITIATED, clusterMembers);
                    gmsStartCluster = true;
                }
                catch (Throwable t) {
                    GMS_LOGGER.log(LogLevel.WARNING, GMS_CLUSTER_START_EXCEPTION, t.getLocalizedMessage());
                }
            }
        }
        finally {
            if (gms != null) {
                GMSAnnounceSupplementalInfo result = new GMSAnnounceSupplementalInfo(clusterMembers, gmsStartCluster, gmsadapter);
                report.setResultType(GMSAnnounceSupplementalInfo.class, (Object)result);
            }
        }
    }

    private List<String> getClusterMembers() {
        List<String> clusterMembers = EMPTY_LIST;
        Cluster cluster = this.domain.getClusterNamed(this.clusterName);
        List targetServers = null;
        if (cluster != null && (targetServers = this.domain.getServersInTarget(this.clusterName)) != null) {
            clusterMembers = new ArrayList<String>(targetServers.size());
            for (Server server : targetServers) {
                clusterMembers.add(server.getName());
            }
        }
        return clusterMembers;
    }
}

