/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.shared.common.reference;

import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ServiceLoader;
import org.apache.derby.shared.api.DerbyModuleAPI;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.info.JVMInfo;

public class ModuleUtil {
    public static final String ENGINE_MODULE_NAME = "org.apache.derby.engine";
    public static final String CLIENT_MODULE_NAME = "org.apache.derby.client";
    public static final String SERVER_MODULE_NAME = "org.apache.derby.server";
    public static final String RUNNER_MODULE_NAME = "org.apache.derby.runner";
    public static final String SHARED_MODULE_NAME = "org.apache.derby.commons";
    public static final String TOOLS_MODULE_NAME = "org.apache.derby.tools";
    public static final String OPTIONALTOOLS_MODULE_NAME = "org.apache.derby.optionaltools";
    public static final String TESTING_MODULE_NAME = "org.apache.derby.tests";
    public static final String LOCALE_MODULE_NAME_PREFIX = "org.apache.derby.locale_";
    private static HashMap<String, Module> _derbyModules;

    public static Module derbyModule(String string) {
        if (!JVMInfo.isModuleAware()) {
            return null;
        }
        ModuleUtil.initModuleInfo();
        return _derbyModules.get(string);
    }

    public static String localizationModuleName(String string) {
        return LOCALE_MODULE_NAME_PREFIX + string;
    }

    public static InputStream getResourceAsStream(String string) throws StandardException {
        Module module;
        ModuleUtil.initModuleInfo();
        InputStream inputStream = null;
        Iterator<Module> iterator = _derbyModules.values().iterator();
        while (iterator.hasNext() && (inputStream = ModuleUtil.getResourceAsStream(module = iterator.next(), string)) == null) {
        }
        return inputStream;
    }

    private static void initModuleInfo() {
        if (_derbyModules != null) {
            return;
        }
        HashMap<String, Module> hashMap = new HashMap<String, Module>();
        ServiceLoader<DerbyModuleAPI> serviceLoader = ServiceLoader.load(DerbyModuleAPI.class);
        for (DerbyModuleAPI derbyModuleAPI : serviceLoader) {
            Class<?> clazz = derbyModuleAPI.getClass();
            Module module = clazz.getModule();
            hashMap.put(module.getName(), module);
        }
        _derbyModules = hashMap;
    }

    private static InputStream getResourceAsStream(final Module module, final String string) throws StandardException {
        InputStream inputStream = null;
        PrivilegedActionException privilegedActionException = null;
        try {
            inputStream = AccessController.doPrivileged(new PrivilegedExceptionAction<InputStream>(){

                @Override
                public InputStream run() throws IOException {
                    return module.getResourceAsStream(string);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException2) {
            privilegedActionException = privilegedActionException2;
        }
        if (privilegedActionException != null) {
            throw StandardException.plainWrapException(privilegedActionException);
        }
        return inputStream;
    }
}

