/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.store;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Enumeration;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public final class PasswordAdapter {
    public static final String PASSWORD_ALIAS_KEYSTORE = "domain-passwords";
    private KeyStore _pwdStore;
    private final File _keyFile;
    private char[] _masterPassword;

    private char[] getMasterPassword() {
        return this._masterPassword;
    }

    private static String getDefaultKeyFileName() {
        return System.getProperty("com.sun.aas.instanceRoot") + File.separator + "config" + File.separator + PASSWORD_ALIAS_KEYSTORE;
    }

    public PasswordAdapter(char[] masterPassword) throws CertificateException, IOException, KeyStoreException, NoSuchAlgorithmException {
        this(PasswordAdapter.getDefaultKeyFileName(), masterPassword);
    }

    public PasswordAdapter(String keyStoreFileName, char[] masterPassword) throws CertificateException, IOException, KeyStoreException, NoSuchAlgorithmException {
        File keyStoreFile = new File(keyStoreFileName);
        this._pwdStore = PasswordAdapter.loadKeyStore(keyStoreFile, masterPassword);
        this._keyFile = keyStoreFile;
        this._masterPassword = masterPassword;
    }

    private static KeyStore loadKeyStore(File keyStoreFile, char[] masterPassword) throws CertificateException, IOException, KeyStoreException, NoSuchAlgorithmException {
        KeyStore keyStore = KeyStore.getInstance("JCEKS");
        if (keyStoreFile.exists()) {
            FileInputStream input;
            try (FileInputStream fileInputStream = input = new FileInputStream(keyStoreFile);){
                keyStore.load(input, masterPassword);
            }
        } else {
            keyStore.load(null, masterPassword);
        }
        return keyStore;
    }

    public synchronized String getPasswordForAlias(String alias) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        String passwordString = null;
        Key key = this._pwdStore.getKey(alias, this.getMasterPassword());
        if (key != null) {
            passwordString = new String(key.getEncoded());
        }
        return passwordString;
    }

    public synchronized SecretKey getPasswordSecretKeyForAlias(String alias) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        return (SecretKey)this._pwdStore.getKey(alias, this.getMasterPassword());
    }

    public synchronized boolean aliasExists(String alias) throws KeyStoreException {
        return this._pwdStore.containsAlias(alias);
    }

    public synchronized void removeAlias(String alias) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException {
        this._pwdStore.deleteEntry(alias);
        this.writeStore();
    }

    public synchronized Enumeration<String> getAliases() throws KeyStoreException {
        return this._pwdStore.aliases();
    }

    public void writeStore() throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException {
        this.writeKeyStoreSafe(this.getMasterPassword());
    }

    public synchronized void setPasswordForAlias(String alias, byte[] keyBytes) throws CertificateException, IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        SecretKeySpec key = new SecretKeySpec(keyBytes, "AES");
        this._pwdStore.setKeyEntry(alias, key, this.getMasterPassword(), null);
        this.writeStore();
    }

    private KeyStore duplicateKeyStore(char[] newMasterPassword) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException {
        char[] oldMasterPassword = this.getMasterPassword();
        KeyStore oldStore = this._pwdStore;
        KeyStore newKeyStore = KeyStore.getInstance("JCEKS", this._pwdStore.getProvider());
        newKeyStore.load(null, newMasterPassword);
        Enumeration<String> aliasesEnum = oldStore.aliases();
        while (aliasesEnum.hasMoreElements()) {
            String alias = aliasesEnum.nextElement();
            if (!oldStore.isKeyEntry(alias)) {
                throw new IllegalArgumentException("Expecting keys only");
            }
            Key key = oldStore.getKey(alias, oldMasterPassword);
            newKeyStore.setKeyEntry(alias, key, newMasterPassword, null);
        }
        return newKeyStore;
    }

    private static void writeKeyStoreToFile(KeyStore keyStore, File file, char[] masterPassword) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        FileOutputStream out;
        try (FileOutputStream fileOutputStream = out = new FileOutputStream(file);){
            keyStore.store(out, masterPassword);
        }
    }

    private synchronized void writeKeyStoreSafe(char[] masterPassword) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException {
        block10: {
            boolean keystoreExists = this._keyFile.exists();
            if (keystoreExists) {
                KeyStore newKeyStore = this.duplicateKeyStore(masterPassword);
                File saveOld = new File(this._keyFile.toString() + ".save");
                if (!this._keyFile.renameTo(saveOld)) {
                    throw new IOException("Can't rename " + this._keyFile + " to " + saveOld);
                }
                try {
                    PasswordAdapter.writeKeyStoreToFile(newKeyStore, this._keyFile, masterPassword);
                    this._pwdStore = newKeyStore;
                    this._masterPassword = masterPassword;
                }
                catch (Throwable t) {
                    try {
                        if (!saveOld.renameTo(this._keyFile)) {
                            throw new RuntimeException("Could not write new KeyStore, and cannot restore KeyStore to original state", t);
                        }
                    }
                    catch (Throwable tt) {
                        throw new RuntimeException("Could not write new KeyStore, and cannot restore KeyStore to original state", tt);
                    }
                    throw new RuntimeException("Can't write new KeyStore", t);
                }
                try {
                    if (!saveOld.delete()) {
                        throw new RuntimeException("Can't remove old KeyStore \"" + this._keyFile + "\"");
                    }
                    break block10;
                }
                catch (Throwable t) {
                    throw new RuntimeException("Can't remove old KeyStore \"" + this._keyFile + "\"", t);
                }
            }
            PasswordAdapter.writeKeyStoreToFile(this._pwdStore, this._keyFile, masterPassword);
        }
        PasswordAdapter.loadKeyStore(this._keyFile, this.getMasterPassword());
    }

    public synchronized void changePassword(char[] newMasterPassword) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException {
        this.writeKeyStoreSafe(newMasterPassword);
    }
}

