/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.codegen;

import com.sun.ejb.codegen.ClassGenerator;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.pfl.dynamic.codegen.impl.ClassGeneratorImpl;
import org.glassfish.pfl.dynamic.codegen.impl.CodeGenerator;
import org.glassfish.pfl.dynamic.codegen.spi.ImportList;
import org.glassfish.pfl.dynamic.codegen.spi.Wrapper;

public abstract class Generator {
    private static final Logger LOG = Logger.getLogger(Generator.class.getName());
    private final ClassLoader loader;

    public Generator(ClassLoader loader) {
        this.loader = Objects.requireNonNull(loader);
    }

    protected abstract String getPackageName();

    public abstract String getGeneratedClassName();

    protected abstract Class<?> getAnchorClass();

    protected abstract void defineClassBody();

    public ClassLoader getClassLoader() {
        return this.loader;
    }

    public Class<?> generate() throws IllegalAccessException {
        if (this.getPackageName() == null) {
            Wrapper._package();
        } else {
            Wrapper._package((String)this.getPackageName());
        }
        ImportList imports = Wrapper._import();
        this.defineClassBody();
        Properties props = new Properties();
        if (LOG.isLoggable(Level.FINEST)) {
            props.put("org.glassfish.dynamic.codegen.debug.dumpAfterSetupVisitor", "true");
            props.put("org.glassfish.dynamic.codegen.debug.traceByteCodeGeneration", "true");
            props.put("org.glassfish.dynamic.codegen.debug.useAsmVerifier", "true");
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                PrintStream ps = new PrintStream(baos);
                Wrapper._sourceCode((PrintStream)ps, (Properties)props);
                LOG.finest(baos.toString());
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, "Exception generating src for logs", e);
            }
        }
        ClassGeneratorImpl codeGenerator = (ClassGeneratorImpl)Wrapper._classGenerator();
        byte[] bytecode = CodeGenerator.generateBytecode((ClassGeneratorImpl)codeGenerator, (ClassLoader)this.getClassLoader(), (ImportList)imports, (Properties)props, (PrintStream)System.out);
        return ClassGenerator.defineClass(this.getClassLoader(), this.getAnchorClass(), this.getPackageName(), this.getGeneratedClassName(), bytecode);
    }

    public static String getPackageName(String fullClassName) {
        int dot = fullClassName.lastIndexOf(46);
        return dot == -1 ? null : fullClassName.substring(0, dot);
    }

    public static String getBaseName(String fullClassName) {
        int dot = fullClassName.lastIndexOf(46);
        return dot == -1 ? fullClassName : fullClassName.substring(dot + 1);
    }

    protected Method[] removeRedundantMethods(Method[] methods) {
        ArrayList<Method> nodups = new ArrayList<Method>();
        for (Method method : methods) {
            boolean duplicationDetected = false;
            ArrayList previousResult = new ArrayList(nodups);
            for (Method alreadyProcessed : previousResult) {
                if (!method.getName().equals(alreadyProcessed.getName()) || !this.haveSameParams(method, alreadyProcessed)) continue;
                duplicationDetected = true;
                if (!alreadyProcessed.getDeclaringClass().isAssignableFrom(method.getDeclaringClass())) break;
                nodups.remove(alreadyProcessed);
                nodups.add(method);
                break;
            }
            if (duplicationDetected) continue;
            nodups.add(method);
        }
        return nodups.toArray(new Method[nodups.size()]);
    }

    private boolean haveSameParams(Method method1, Method method2) {
        Class<?>[] m2parms;
        Class<?>[] m1parms = method1.getParameterTypes();
        if (m1parms.length != (m2parms = method2.getParameterTypes()).length) {
            return false;
        }
        for (int i = 0; i < m2parms.length; ++i) {
            if (m1parms[i] == m2parms[i]) continue;
            return false;
        }
        return true;
    }
}

