/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.util;

import jakarta.faces.context.FacesContext;
import jakarta.servlet.http.Cookie;

public final class CookieUtils {
    private static final char[] BAD_COOKIE_CHARS = new char[]{'(', ')', '<', '>', '@', ',', ';', ':', '\\', '\'', '/', '[', ']', '?', '=', '{', '}', ' ', '\t'};

    private CookieUtils() {
    }

    public static Cookie getCookieValue(FacesContext context, String name) {
        String cookieName = CookieUtils.getValidCookieName(name);
        return (Cookie)context.getExternalContext().getRequestCookieMap().get(cookieName);
    }

    public static void setCookieValue(FacesContext context, String name, String value) {
        String cookieName = CookieUtils.getValidCookieName(name);
        context.getExternalContext().getRequestCookieMap().put(cookieName, value);
    }

    public static String getValidCookieName(String name) {
        String cookieName = name;
        for (char ch : BAD_COOKIE_CHARS) {
            cookieName = cookieName.replace(ch, '_');
        }
        return cookieName;
    }
}

