/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.util;

import jakarta.json.Json;
import jakarta.json.JsonBuilderFactory;
import jakarta.json.JsonObject;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import jakarta.json.JsonWriter;
import jakarta.json.JsonWriterFactory;
import jakarta.json.stream.JsonParserFactory;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.HashMap;

public final class JsonUtilities {
    public static final JsonBuilderFactory JSON_BUILDER_FACTORY = Json.createBuilderFactory(null);
    public static final JsonWriterFactory JSON_WRITER_FACTORY = JsonUtilities.createJsonWriterFactory();
    public static final JsonParserFactory JSON_PARSER_FACTORY = Json.createParserFactory(null);

    private JsonUtilities() {
    }

    public static void writeJsonObject(JsonObject json, Writer writer) {
        JsonWriter jsonWriter = JSON_WRITER_FACTORY.createWriter(writer);
        jsonWriter.writeObject(json);
    }

    public static JsonObject parseJsonObject(String input) {
        return JSON_PARSER_FACTORY.createParser((Reader)new StringReader(input)).getObject();
    }

    public static JsonValue jsonValueOf(Object value) {
        JsonString jsonValue;
        if (value == null) {
            return JsonValue.NULL;
        }
        if (value instanceof String) {
            jsonValue = Json.createValue((String)((String)value));
        } else if (value instanceof Integer) {
            jsonValue = Json.createValue((int)((Integer)value));
        } else if (value instanceof Double) {
            jsonValue = Json.createValue((double)((Double)value));
        } else if (value instanceof Long) {
            jsonValue = Json.createValue((long)((Long)value));
        } else {
            throw new IllegalStateException("Unsupported type: " + value.getClass());
        }
        return jsonValue;
    }

    private static JsonWriterFactory createJsonWriterFactory() {
        HashMap<String, Boolean> config = new HashMap<String, Boolean>();
        config.put("jakarta.json.stream.JsonGenerator.prettyPrinting", true);
        return Json.createWriterFactory(config);
    }
}

